<?php
// 1. Hook the registration function to the 'rest_api_init' action
add_action('rest_api_init', 'user_account_api_register_routes');

function user_account_api_register_routes()
{
    $namespace = 'api/v1'; // Namespace for your custom route prefixed with /wp-json/
    $route = '/user-account';          // The specific route segment

    register_rest_route($namespace, $route, array(
        'methods' => 'POST', // HTTP method (GET, POST, etc.)
        'callback' => 'user_account_api_callback', // Function to execute
        'permission_callback' => '__return_true', // Authentication check (true for public)
    ));
}

// 2. The Callback Function
function user_account_api_callback($request)
{
    $params = $request->get_params();

    if ($params['formAction'] == 'register-user') {
        $username = $params['userName'];
        $firstName = $params['firstName'];
        $lastName = $params['lastName'];
        $password = $params['password'];
        $confirmPassword = $params['confirmPassword'];
        $email = $params['userName'] . '@email.com';

        if ($username != "") {
            if ($firstName != "" && $lastName != "") {
                if ($password != "") {
                    if ($password == $confirmPassword) {
                        $user_id = wp_create_user($params['userName'], $params['password'], $email);

                        if (!is_wp_error($user_id)) {
                            update_user_meta($user_id, 'first_name', $params['firstName']);
                            update_user_meta($user_id, 'last_name', $params['lastName']);

                            $data = array(
                                'register' => true,
                                'message' => 'The user is registered successfully!',
                                'time' => current_time('mysql')
                            );
                        } else {
                            //$params['error'] = $user_id;

                            $data = array(
                                'register' => false,
                                'message' => 'The user is already registered!',
                                'time' => current_time('mysql'),
                                'error' => $user_id
                            );
                        }
                    } else {
                        $data = array(
                            'register' => false,
                            'message' => 'The password confirmation is invalid!',
                            'time' => current_time('mysql')
                        );
                    }

                } else {
                    $data = array(
                        'register' => false,
                        'message' => 'The password should not be empty!',
                        'time' => current_time('mysql')
                    );
                }

            } else {
                $data = array(
                    'register' => false,
                    'message' => 'You have to type a Firstname and a Lastname!',
                    'time' => current_time('mysql'),
                    'params' => $params
                );
            }

        } else {
            $data = array(
                'register' => false,
                'message' => 'You have to type a username!',
                'time' => current_time('mysql')
            );
        }


    } else

        if ($params['formAction'] == 'login-user') {
            $username = $params['username'];
            $password = $params['password'];

            if ($username != "") {
                if ($password != "") {
                    // Retrieve the user object by login (username)
                    $user = get_user_by('login', $username);

                    // Check if the user exists
                    if ($user) {
                        // The hashed password is stored in the 'user_pass' property
                        $hashed_password = $user->user_pass;

                        // Check the raw password against the stored hash
                        $is_password_correct = wp_check_password($password, $hashed_password, $user->ID);

                        if ($is_password_correct) {
                            $_SESSION['username'] = $username;
                            $_SESSION['user_id'] = $user->ID;
                            //$_SESSION['order_id'] = 1;
                            $_SESSION['order_id'] = createNewOrder($_SESSION['user_id']);

                            wp_clear_auth_cookie();
                            wp_set_current_user($user->ID);
                            wp_set_auth_cookie($user->ID);

                            // Update user meta if needed (optional)
                            update_user_meta($user->ID, 'last_login', current_time('mysql'));

                            // Redirect after login
                            //wp_redirect(home_url());

                            $data = array(
                                'login' => true,
                                'message' => "The user is logged in successfully!",
                                'time' => current_time('mysql')
                            );
                        } else {
                            $data = array(
                                'login' => false,
                                'message' => "Provided password is incorrect!",
                                'time' => current_time('mysql')
                            );
                        }

                    } else {
                        $data = array(
                            'login' => false,
                            'message' => "The user doesn't exist!",
                            'time' => current_time('mysql')
                        );
                    }
                } else {
                    $data = array(
                        'login' => false,
                        'message' => "You provided an empty password!",
                        'time' => current_time('mysql')
                    );
                }

            } else {
                $data = array(
                    'login' => false,
                    'message' => "You have to type a username!",
                    'time' => current_time('mysql')
                );
            }

        } else

            if ($params['formAction'] == "logout-user") {
                unset($_SESSION['username']);
                unset($_SESSION['user_id']);
                unset($_SESSION['order_id']);
                
                wp_logout();

                $data = array(
                    'logout' => true
                );

            } else
                if ($params['formAction'] == 'save-user-infos') {
                    $username = $params['userName'];
                    $firstName = $params['firstName'];
                    $lastName = $params['lastName'];

                    try {
                        $user = get_user_by('login', $username);
                        update_user_meta($user->ID, 'first_name', $params['firstName']);
                        update_user_meta($user->ID, 'last_name', $params['lastName']);
                        //echo 'The user infos was updated successfully!';
                        $data = array(
                            'update' => true,
                            'message' => "The user infos was updated successfully!",
                            'time' => current_time('mysql')
                        );
                    } catch (Exception $ex) {
                        //echo 'Exception: ' . $ex->getMessage() . '<br>' ;
                        $data = array(
                            'update' => false,
                            'message' => "' . $ex->getMessage() . '",
                            'time' => current_time('mysql')
                        );
                    }
                } else
                    if ($params['formAction'] == 'change-user-password') {
                        $username = $params['userName'];
                        $currentPassword = $params['currentPassword'];
                        $newPassword = $params['newPassword'];
                        $confirmPassword = $params['confirmPassword'];

                        $user = get_user_by('login', $username);

                        // Check if the user exists
                        if ($user) {
                            // The hashed password is stored in the 'user_pass' property
                            $hashed_password = $user->user_pass;

                            // Check the raw password against the stored hash
                            $is_password_correct = wp_check_password($currentPassword, $hashed_password, $user->ID);

                            if ($is_password_correct) {

                                if ($newPassword != "") {
                                    if ($newPassword == $confirmPassword) {

                                        wp_set_password($newPassword, $user->ID);
                                        
                                        $data = array(
                                            'update' => true,
                                            'message' => "The user password was updated successfully!",
                                            'time' => current_time('mysql')
                                        );

                                    } else {
                                        $data = array(
                                            'update' => false,
                                            'message' => "The confirmation of the new password is invalid!",
                                            'time' => current_time('mysql')
                                        );
                                    }

                                } else {
                                    $data = array(
                                            'update' => false,
                                            'message' => "The new password should not be empty!",
                                            'time' => current_time('mysql')
                                        );
                                }

                            } else {
                                $data = array(
                                            'update' => false,
                                            'message' => "The provided current password is wrong!",
                                            'time' => current_time('mysql')
                                        );
                            }
                        }
                    }


    // Always return a WP_REST_Response object
    return new WP_REST_Response($data, 200);
}
?>