<?php
/**
 * CustomerPaymentInstrumentApi
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Api;

use \CyberSource\ApiClient;
use \CyberSource\ApiException;
use \CyberSource\Configuration;
use \CyberSource\ObjectSerializer;
use \CyberSource\Logging\LogFactory as LogFactory;
use \CyberSource\Authentication\Util\MLEUtility;
use \CyberSource\Utilities\MultipartHelpers\MultipartHelper;
use \Exception;

/**
 * CustomerPaymentInstrumentApi Class Doc Comment
 *
 * @category Class
 * @package  CyberSource
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CustomerPaymentInstrumentApi
{
    private static $logger = null;
    
    /**
     * API Client
     *
     * @var \CyberSource\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \CyberSource\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\CyberSource\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;

        if (self::$logger === null) {
            self::$logger = (new LogFactory())->getLogger(\CyberSource\Utilities\Helpers\ClassHelper::getClassName(get_class($this)), $apiClient->merchantConfig->getLogConfiguration());
        }
    }

    /**
     * Get API client
     *
     * @return \CyberSource\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \CyberSource\ApiClient $apiClient set the API client
     *
     * @return CustomerPaymentInstrumentApi
     */
    public function setApiClient(\CyberSource\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteCustomerPaymentInstrument
     *
     * Delete a Customer Payment Instrument
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param string $paymentInstrumentId The Id of a payment instrument. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of void, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomerPaymentInstrument($customerId, $paymentInstrumentId, $profileId = null)
    {
        self::$logger->info('CALL TO METHOD deleteCustomerPaymentInstrument STARTED');
        list($response, $statusCode, $httpHeader) = $this->deleteCustomerPaymentInstrumentWithHttpInfo($customerId, $paymentInstrumentId, $profileId);
        self::$logger->info('CALL TO METHOD deleteCustomerPaymentInstrument ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation deleteCustomerPaymentInstrumentWithHttpInfo
     *
     * Delete a Customer Payment Instrument
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param string $paymentInstrumentId The Id of a payment instrument. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomerPaymentInstrumentWithHttpInfo($customerId, $paymentInstrumentId, $profileId = null)
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $customerId when calling deleteCustomerPaymentInstrument");
            throw new \InvalidArgumentException('Missing the required parameter $customerId when calling deleteCustomerPaymentInstrument');
        }
        // verify the required parameter 'paymentInstrumentId' is set
        if ($paymentInstrumentId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $paymentInstrumentId when calling deleteCustomerPaymentInstrument");
            throw new \InvalidArgumentException('Missing the required parameter $paymentInstrumentId when calling deleteCustomerPaymentInstrument');
        }
        // parse inputs
        $resourcePath = "/tms/v2/customers/{customerId}/payment-instruments/{paymentInstrumentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                "{" . "customerId" . "}",
                $this->apiClient->getSerializer()->toPathValue($customerId),
                $resourcePath
            );
        }
        // path params
        if ($paymentInstrumentId !== null) {
            $resourcePath = str_replace(
                "{" . "paymentInstrumentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($paymentInstrumentId),
                $resourcePath
            );
        }
        if ('DELETE' == 'POST') {
            $_tempBody = '{}';
        }

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "deleteCustomerPaymentInstrument,deleteCustomerPaymentInstrumentWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : DELETE $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : null");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/tms/v2/customers/{customerId}/payment-instruments/{paymentInstrumentId}'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$response, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse409', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation getCustomerPaymentInstrument
     *
     * Retrieve a Customer Payment Instrument
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param string $paymentInstrumentId The Id of a payment instrument. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PostCustomerPaymentInstrumentRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerPaymentInstrument($customerId, $paymentInstrumentId, $profileId = null)
    {
        self::$logger->info('CALL TO METHOD getCustomerPaymentInstrument STARTED');
        list($response, $statusCode, $httpHeader) = $this->getCustomerPaymentInstrumentWithHttpInfo($customerId, $paymentInstrumentId, $profileId);
        self::$logger->info('CALL TO METHOD getCustomerPaymentInstrument ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation getCustomerPaymentInstrumentWithHttpInfo
     *
     * Retrieve a Customer Payment Instrument
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param string $paymentInstrumentId The Id of a payment instrument. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PostCustomerPaymentInstrumentRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerPaymentInstrumentWithHttpInfo($customerId, $paymentInstrumentId, $profileId = null)
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $customerId when calling getCustomerPaymentInstrument");
            throw new \InvalidArgumentException('Missing the required parameter $customerId when calling getCustomerPaymentInstrument');
        }
        // verify the required parameter 'paymentInstrumentId' is set
        if ($paymentInstrumentId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $paymentInstrumentId when calling getCustomerPaymentInstrument");
            throw new \InvalidArgumentException('Missing the required parameter $paymentInstrumentId when calling getCustomerPaymentInstrument');
        }
        // parse inputs
        $resourcePath = "/tms/v2/customers/{customerId}/payment-instruments/{paymentInstrumentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                "{" . "customerId" . "}",
                $this->apiClient->getSerializer()->toPathValue($customerId),
                $resourcePath
            );
        }
        // path params
        if ($paymentInstrumentId !== null) {
            $resourcePath = str_replace(
                "{" . "paymentInstrumentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($paymentInstrumentId),
                $resourcePath
            );
        }
        if ('GET' == 'POST') {
            $_tempBody = '{}';
        }

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "getCustomerPaymentInstrument,getCustomerPaymentInstrumentWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : GET $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\PostCustomerPaymentInstrumentRequest");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\PostCustomerPaymentInstrumentRequest',
                '/tms/v2/customers/{customerId}/payment-instruments/{paymentInstrumentId}'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\PostCustomerPaymentInstrumentRequest', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PostCustomerPaymentInstrumentRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation getCustomerPaymentInstrumentsList
     *
     * List Payment Instruments for a Customer
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param int $offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param int $limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PaymentInstrumentList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerPaymentInstrumentsList($customerId, $profileId = null, $offset = '0', $limit = '20')
    {
        self::$logger->info('CALL TO METHOD getCustomerPaymentInstrumentsList STARTED');
        list($response, $statusCode, $httpHeader) = $this->getCustomerPaymentInstrumentsListWithHttpInfo($customerId, $profileId, $offset, $limit);
        self::$logger->info('CALL TO METHOD getCustomerPaymentInstrumentsList ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation getCustomerPaymentInstrumentsListWithHttpInfo
     *
     * List Payment Instruments for a Customer
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param int $offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param int $limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PaymentInstrumentList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerPaymentInstrumentsListWithHttpInfo($customerId, $profileId = null, $offset = '0', $limit = '20')
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $customerId when calling getCustomerPaymentInstrumentsList");
            throw new \InvalidArgumentException('Missing the required parameter $customerId when calling getCustomerPaymentInstrumentsList');
        }
        // parse inputs
        $resourcePath = "/tms/v2/customers/{customerId}/payment-instruments";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // query params
        if ($offset !== null) {
            $queryParams['offset'] = $this->apiClient->getSerializer()->toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $this->apiClient->getSerializer()->toQueryValue($limit);
        }
        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                "{" . "customerId" . "}",
                $this->apiClient->getSerializer()->toPathValue($customerId),
                $resourcePath
            );
        }
        if ('GET' == 'POST') {
            $_tempBody = '{}';
        }

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "getCustomerPaymentInstrumentsList,getCustomerPaymentInstrumentsListWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : GET $resourcePath");
        self::$logger->debug("Query Parameters :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($queryParams));
        self::$logger->debug("Query Parameters :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($queryParams));
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\PaymentInstrumentList");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\PaymentInstrumentList',
                '/tms/v2/customers/{customerId}/payment-instruments'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\PaymentInstrumentList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PaymentInstrumentList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation patchCustomersPaymentInstrument
     *
     * Update a Customer Payment Instrument
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param string $paymentInstrumentId The Id of a payment instrument. (required)
     * @param \CyberSource\Model\PatchCustomerPaymentInstrumentRequest $patchCustomerPaymentInstrumentRequest  (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param string $ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PatchCustomerPaymentInstrumentRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchCustomersPaymentInstrument($customerId, $paymentInstrumentId, $patchCustomerPaymentInstrumentRequest, $profileId = null, $ifMatch = null)
    {
        self::$logger->info('CALL TO METHOD patchCustomersPaymentInstrument STARTED');
        list($response, $statusCode, $httpHeader) = $this->patchCustomersPaymentInstrumentWithHttpInfo($customerId, $paymentInstrumentId, $patchCustomerPaymentInstrumentRequest, $profileId, $ifMatch);
        self::$logger->info('CALL TO METHOD patchCustomersPaymentInstrument ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation patchCustomersPaymentInstrumentWithHttpInfo
     *
     * Update a Customer Payment Instrument
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param string $paymentInstrumentId The Id of a payment instrument. (required)
     * @param \CyberSource\Model\PatchCustomerPaymentInstrumentRequest $patchCustomerPaymentInstrumentRequest  (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param string $ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PatchCustomerPaymentInstrumentRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchCustomersPaymentInstrumentWithHttpInfo($customerId, $paymentInstrumentId, $patchCustomerPaymentInstrumentRequest, $profileId = null, $ifMatch = null)
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $customerId when calling patchCustomersPaymentInstrument");
            throw new \InvalidArgumentException('Missing the required parameter $customerId when calling patchCustomersPaymentInstrument');
        }
        // verify the required parameter 'paymentInstrumentId' is set
        if ($paymentInstrumentId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $paymentInstrumentId when calling patchCustomersPaymentInstrument");
            throw new \InvalidArgumentException('Missing the required parameter $paymentInstrumentId when calling patchCustomersPaymentInstrument');
        }
        // verify the required parameter 'patchCustomerPaymentInstrumentRequest' is set
        if ($patchCustomerPaymentInstrumentRequest === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $patchCustomerPaymentInstrumentRequest when calling patchCustomersPaymentInstrument");
            throw new \InvalidArgumentException('Missing the required parameter $patchCustomerPaymentInstrumentRequest when calling patchCustomersPaymentInstrument');
        }
        // parse inputs
        $resourcePath = "/tms/v2/customers/{customerId}/payment-instruments/{paymentInstrumentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // header params
        if ($ifMatch !== null) {
            $headerParams['if-match'] = $this->apiClient->getSerializer()->toHeaderValue($ifMatch);
        }
        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                "{" . "customerId" . "}",
                $this->apiClient->getSerializer()->toPathValue($customerId),
                $resourcePath
            );
        }
        // path params
        if ($paymentInstrumentId !== null) {
            $resourcePath = str_replace(
                "{" . "paymentInstrumentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($paymentInstrumentId),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($patchCustomerPaymentInstrumentRequest)) {
            $_tempBody = $patchCustomerPaymentInstrumentRequest;
        }
        
        $sdkTracker = new \CyberSource\Utilities\Tracking\SdkTracker();
        $modelClassLocation = explode('\\', '\CyberSource\Model\PatchCustomerPaymentInstrumentRequest');

        $_tempBody = $sdkTracker->insertDeveloperIdTracker($_tempBody, end($modelClassLocation), $this->apiClient->merchantConfig->getRunEnvironment(), $this->apiClient->merchantConfig->getDefaultDeveloperId());

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "patchCustomersPaymentInstrument,patchCustomersPaymentInstrumentWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : PATCH $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\PatchCustomerPaymentInstrumentRequest");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\PatchCustomerPaymentInstrumentRequest',
                '/tms/v2/customers/{customerId}/payment-instruments/{paymentInstrumentId}'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\PatchCustomerPaymentInstrumentRequest', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PatchCustomerPaymentInstrumentRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 412:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse412', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation postCustomerPaymentInstrument
     *
     * Create a Customer Payment Instrument
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param \CyberSource\Model\PostCustomerPaymentInstrumentRequest $postCustomerPaymentInstrumentRequest  (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PostCustomerPaymentInstrumentRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function postCustomerPaymentInstrument($customerId, $postCustomerPaymentInstrumentRequest, $profileId = null)
    {
        self::$logger->info('CALL TO METHOD postCustomerPaymentInstrument STARTED');
        list($response, $statusCode, $httpHeader) = $this->postCustomerPaymentInstrumentWithHttpInfo($customerId, $postCustomerPaymentInstrumentRequest, $profileId);
        self::$logger->info('CALL TO METHOD postCustomerPaymentInstrument ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation postCustomerPaymentInstrumentWithHttpInfo
     *
     * Create a Customer Payment Instrument
     *
     * @param string $customerId The Id of a Customer. (required)
     * @param \CyberSource\Model\PostCustomerPaymentInstrumentRequest $postCustomerPaymentInstrumentRequest  (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PostCustomerPaymentInstrumentRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function postCustomerPaymentInstrumentWithHttpInfo($customerId, $postCustomerPaymentInstrumentRequest, $profileId = null)
    {
        // verify the required parameter 'customerId' is set
        if ($customerId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $customerId when calling postCustomerPaymentInstrument");
            throw new \InvalidArgumentException('Missing the required parameter $customerId when calling postCustomerPaymentInstrument');
        }
        // verify the required parameter 'postCustomerPaymentInstrumentRequest' is set
        if ($postCustomerPaymentInstrumentRequest === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $postCustomerPaymentInstrumentRequest when calling postCustomerPaymentInstrument");
            throw new \InvalidArgumentException('Missing the required parameter $postCustomerPaymentInstrumentRequest when calling postCustomerPaymentInstrument');
        }
        // parse inputs
        $resourcePath = "/tms/v2/customers/{customerId}/payment-instruments";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // path params
        if ($customerId !== null) {
            $resourcePath = str_replace(
                "{" . "customerId" . "}",
                $this->apiClient->getSerializer()->toPathValue($customerId),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($postCustomerPaymentInstrumentRequest)) {
            $_tempBody = $postCustomerPaymentInstrumentRequest;
        }
        
        $sdkTracker = new \CyberSource\Utilities\Tracking\SdkTracker();
        $modelClassLocation = explode('\\', '\CyberSource\Model\PostCustomerPaymentInstrumentRequest');

        $_tempBody = $sdkTracker->insertDeveloperIdTracker($_tempBody, end($modelClassLocation), $this->apiClient->merchantConfig->getRunEnvironment(), $this->apiClient->merchantConfig->getDefaultDeveloperId());

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "postCustomerPaymentInstrument,postCustomerPaymentInstrumentWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : POST $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\PostCustomerPaymentInstrumentRequest");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\PostCustomerPaymentInstrumentRequest',
                '/tms/v2/customers/{customerId}/payment-instruments'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\PostCustomerPaymentInstrumentRequest', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PostCustomerPaymentInstrumentRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse409', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }
}
