<?php
/**
 * InstrumentIdentifierApi
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Api;

use \CyberSource\ApiClient;
use \CyberSource\ApiException;
use \CyberSource\Configuration;
use \CyberSource\ObjectSerializer;
use \CyberSource\Logging\LogFactory as LogFactory;
use \CyberSource\Authentication\Util\MLEUtility;
use \CyberSource\Utilities\MultipartHelpers\MultipartHelper;
use \Exception;

/**
 * InstrumentIdentifierApi Class Doc Comment
 *
 * @category Class
 * @package  CyberSource
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class InstrumentIdentifierApi
{
    private static $logger = null;
    
    /**
     * API Client
     *
     * @var \CyberSource\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \CyberSource\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\CyberSource\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;

        if (self::$logger === null) {
            self::$logger = (new LogFactory())->getLogger(\CyberSource\Utilities\Helpers\ClassHelper::getClassName(get_class($this)), $apiClient->merchantConfig->getLogConfiguration());
        }
    }

    /**
     * Get API client
     *
     * @return \CyberSource\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \CyberSource\ApiClient $apiClient set the API client
     *
     * @return InstrumentIdentifierApi
     */
    public function setApiClient(\CyberSource\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteInstrumentIdentifier
     *
     * Delete an Instrument Identifier
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of void, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInstrumentIdentifier($instrumentIdentifierId, $profileId = null)
    {
        self::$logger->info('CALL TO METHOD deleteInstrumentIdentifier STARTED');
        list($response, $statusCode, $httpHeader) = $this->deleteInstrumentIdentifierWithHttpInfo($instrumentIdentifierId, $profileId);
        self::$logger->info('CALL TO METHOD deleteInstrumentIdentifier ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation deleteInstrumentIdentifierWithHttpInfo
     *
     * Delete an Instrument Identifier
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInstrumentIdentifierWithHttpInfo($instrumentIdentifierId, $profileId = null)
    {
        // verify the required parameter 'instrumentIdentifierId' is set
        if ($instrumentIdentifierId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $instrumentIdentifierId when calling deleteInstrumentIdentifier");
            throw new \InvalidArgumentException('Missing the required parameter $instrumentIdentifierId when calling deleteInstrumentIdentifier');
        }
        // parse inputs
        $resourcePath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // path params
        if ($instrumentIdentifierId !== null) {
            $resourcePath = str_replace(
                "{" . "instrumentIdentifierId" . "}",
                $this->apiClient->getSerializer()->toPathValue($instrumentIdentifierId),
                $resourcePath
            );
        }
        if ('DELETE' == 'POST') {
            $_tempBody = '{}';
        }

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "deleteInstrumentIdentifier,deleteInstrumentIdentifierWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : DELETE $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : null");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/tms/v1/instrumentidentifiers/{instrumentIdentifierId}'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$response, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse409', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation getInstrumentIdentifier
     *
     * Retrieve an Instrument Identifier
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param bool $retrieveBinDetails Retrieve the Bin Details of PAN or network token (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PostInstrumentIdentifierRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInstrumentIdentifier($instrumentIdentifierId, $profileId = null, $retrieveBinDetails = null)
    {
        self::$logger->info('CALL TO METHOD getInstrumentIdentifier STARTED');
        list($response, $statusCode, $httpHeader) = $this->getInstrumentIdentifierWithHttpInfo($instrumentIdentifierId, $profileId, $retrieveBinDetails);
        self::$logger->info('CALL TO METHOD getInstrumentIdentifier ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation getInstrumentIdentifierWithHttpInfo
     *
     * Retrieve an Instrument Identifier
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param bool $retrieveBinDetails Retrieve the Bin Details of PAN or network token (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PostInstrumentIdentifierRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInstrumentIdentifierWithHttpInfo($instrumentIdentifierId, $profileId = null, $retrieveBinDetails = null)
    {
        // verify the required parameter 'instrumentIdentifierId' is set
        if ($instrumentIdentifierId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $instrumentIdentifierId when calling getInstrumentIdentifier");
            throw new \InvalidArgumentException('Missing the required parameter $instrumentIdentifierId when calling getInstrumentIdentifier');
        }
        // parse inputs
        $resourcePath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // query params
        if ($retrieveBinDetails !== null) {
            $queryParams['retrieveBinDetails'] = $this->apiClient->getSerializer()->toQueryValue($retrieveBinDetails);
        }
        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // path params
        if ($instrumentIdentifierId !== null) {
            $resourcePath = str_replace(
                "{" . "instrumentIdentifierId" . "}",
                $this->apiClient->getSerializer()->toPathValue($instrumentIdentifierId),
                $resourcePath
            );
        }
        if ('GET' == 'POST') {
            $_tempBody = '{}';
        }

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "getInstrumentIdentifier,getInstrumentIdentifierWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : GET $resourcePath");
        self::$logger->debug("Query Parameters :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($queryParams));
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\PostInstrumentIdentifierRequest");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\PostInstrumentIdentifierRequest',
                '/tms/v1/instrumentidentifiers/{instrumentIdentifierId}'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\PostInstrumentIdentifierRequest', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PostInstrumentIdentifierRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation getInstrumentIdentifierPaymentInstrumentsList
     *
     * List Payment Instruments for an Instrument Identifier
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param bool $retrieveBinDetails Retrieve the Bin Details of PAN or network token (optional)
     * @param int $offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param int $limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PaymentInstrumentList1, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInstrumentIdentifierPaymentInstrumentsList($instrumentIdentifierId, $profileId = null, $retrieveBinDetails = null, $offset = '0', $limit = '20')
    {
        self::$logger->info('CALL TO METHOD getInstrumentIdentifierPaymentInstrumentsList STARTED');
        list($response, $statusCode, $httpHeader) = $this->getInstrumentIdentifierPaymentInstrumentsListWithHttpInfo($instrumentIdentifierId, $profileId, $retrieveBinDetails, $offset, $limit);
        self::$logger->info('CALL TO METHOD getInstrumentIdentifierPaymentInstrumentsList ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation getInstrumentIdentifierPaymentInstrumentsListWithHttpInfo
     *
     * List Payment Instruments for an Instrument Identifier
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param bool $retrieveBinDetails Retrieve the Bin Details of PAN or network token (optional)
     * @param int $offset Starting record in zero-based dataset that should be returned as the first object in the array. Default is 0. (optional, default to 0)
     * @param int $limit The maximum number that can be returned in the array starting from the offset record in zero-based dataset. Default is 20, maximum is 100. (optional, default to 20)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PaymentInstrumentList1, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInstrumentIdentifierPaymentInstrumentsListWithHttpInfo($instrumentIdentifierId, $profileId = null, $retrieveBinDetails = null, $offset = '0', $limit = '20')
    {
        // verify the required parameter 'instrumentIdentifierId' is set
        if ($instrumentIdentifierId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $instrumentIdentifierId when calling getInstrumentIdentifierPaymentInstrumentsList");
            throw new \InvalidArgumentException('Missing the required parameter $instrumentIdentifierId when calling getInstrumentIdentifierPaymentInstrumentsList');
        }
        // parse inputs
        $resourcePath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierId}/paymentinstruments";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // query params
        if ($retrieveBinDetails !== null) {
            $queryParams['retrieveBinDetails'] = $this->apiClient->getSerializer()->toQueryValue($retrieveBinDetails);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = $this->apiClient->getSerializer()->toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $this->apiClient->getSerializer()->toQueryValue($limit);
        }
        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // path params
        if ($instrumentIdentifierId !== null) {
            $resourcePath = str_replace(
                "{" . "instrumentIdentifierId" . "}",
                $this->apiClient->getSerializer()->toPathValue($instrumentIdentifierId),
                $resourcePath
            );
        }
        if ('GET' == 'POST') {
            $_tempBody = '{}';
        }

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "getInstrumentIdentifierPaymentInstrumentsList,getInstrumentIdentifierPaymentInstrumentsListWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : GET $resourcePath");
        self::$logger->debug("Query Parameters :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($queryParams));
        self::$logger->debug("Query Parameters :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($queryParams));
        self::$logger->debug("Query Parameters :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($queryParams));
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\PaymentInstrumentList1");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\PaymentInstrumentList1',
                '/tms/v1/instrumentidentifiers/{instrumentIdentifierId}/paymentinstruments'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\PaymentInstrumentList1', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PaymentInstrumentList1', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation patchInstrumentIdentifier
     *
     * Update an Instrument Identifier
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param \CyberSource\Model\PatchInstrumentIdentifierRequest $patchInstrumentIdentifierRequest Specify the previous transaction Id to update. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param bool $retrieveBinDetails Retrieve the Bin Details of PAN or network token (optional)
     * @param string $ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PatchInstrumentIdentifierRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchInstrumentIdentifier($instrumentIdentifierId, $patchInstrumentIdentifierRequest, $profileId = null, $retrieveBinDetails = null, $ifMatch = null)
    {
        self::$logger->info('CALL TO METHOD patchInstrumentIdentifier STARTED');
        list($response, $statusCode, $httpHeader) = $this->patchInstrumentIdentifierWithHttpInfo($instrumentIdentifierId, $patchInstrumentIdentifierRequest, $profileId, $retrieveBinDetails, $ifMatch);
        self::$logger->info('CALL TO METHOD patchInstrumentIdentifier ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation patchInstrumentIdentifierWithHttpInfo
     *
     * Update an Instrument Identifier
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param \CyberSource\Model\PatchInstrumentIdentifierRequest $patchInstrumentIdentifierRequest Specify the previous transaction Id to update. (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param bool $retrieveBinDetails Retrieve the Bin Details of PAN or network token (optional)
     * @param string $ifMatch Contains an ETag value from a GET request to make the request conditional. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PatchInstrumentIdentifierRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchInstrumentIdentifierWithHttpInfo($instrumentIdentifierId, $patchInstrumentIdentifierRequest, $profileId = null, $retrieveBinDetails = null, $ifMatch = null)
    {
        // verify the required parameter 'instrumentIdentifierId' is set
        if ($instrumentIdentifierId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $instrumentIdentifierId when calling patchInstrumentIdentifier");
            throw new \InvalidArgumentException('Missing the required parameter $instrumentIdentifierId when calling patchInstrumentIdentifier');
        }
        // verify the required parameter 'patchInstrumentIdentifierRequest' is set
        if ($patchInstrumentIdentifierRequest === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $patchInstrumentIdentifierRequest when calling patchInstrumentIdentifier");
            throw new \InvalidArgumentException('Missing the required parameter $patchInstrumentIdentifierRequest when calling patchInstrumentIdentifier');
        }
        // parse inputs
        $resourcePath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // query params
        if ($retrieveBinDetails !== null) {
            $queryParams['retrieveBinDetails'] = $this->apiClient->getSerializer()->toQueryValue($retrieveBinDetails);
        }
        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // header params
        if ($ifMatch !== null) {
            $headerParams['if-match'] = $this->apiClient->getSerializer()->toHeaderValue($ifMatch);
        }
        // path params
        if ($instrumentIdentifierId !== null) {
            $resourcePath = str_replace(
                "{" . "instrumentIdentifierId" . "}",
                $this->apiClient->getSerializer()->toPathValue($instrumentIdentifierId),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($patchInstrumentIdentifierRequest)) {
            $_tempBody = $patchInstrumentIdentifierRequest;
        }
        
        $sdkTracker = new \CyberSource\Utilities\Tracking\SdkTracker();
        $modelClassLocation = explode('\\', '\CyberSource\Model\PatchInstrumentIdentifierRequest');

        $_tempBody = $sdkTracker->insertDeveloperIdTracker($_tempBody, end($modelClassLocation), $this->apiClient->merchantConfig->getRunEnvironment(), $this->apiClient->merchantConfig->getDefaultDeveloperId());

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "patchInstrumentIdentifier,patchInstrumentIdentifierWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : PATCH $resourcePath");
        self::$logger->debug("Query Parameters :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($queryParams));
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\PatchInstrumentIdentifierRequest");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\PatchInstrumentIdentifierRequest',
                '/tms/v1/instrumentidentifiers/{instrumentIdentifierId}'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\PatchInstrumentIdentifierRequest', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PatchInstrumentIdentifierRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 412:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse412', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation postInstrumentIdentifier
     *
     * Create an Instrument Identifier
     *
     * @param \CyberSource\Model\PostInstrumentIdentifierRequest $postInstrumentIdentifierRequest Specify either a Card, Bank Account or Enrollable Card (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param bool $retrieveBinDetails Retrieve the Bin Details of PAN or network token (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PostInstrumentIdentifierRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function postInstrumentIdentifier($postInstrumentIdentifierRequest, $profileId = null, $retrieveBinDetails = null)
    {
        self::$logger->info('CALL TO METHOD postInstrumentIdentifier STARTED');
        list($response, $statusCode, $httpHeader) = $this->postInstrumentIdentifierWithHttpInfo($postInstrumentIdentifierRequest, $profileId, $retrieveBinDetails);
        self::$logger->info('CALL TO METHOD postInstrumentIdentifier ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation postInstrumentIdentifierWithHttpInfo
     *
     * Create an Instrument Identifier
     *
     * @param \CyberSource\Model\PostInstrumentIdentifierRequest $postInstrumentIdentifierRequest Specify either a Card, Bank Account or Enrollable Card (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @param bool $retrieveBinDetails Retrieve the Bin Details of PAN or network token (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\PostInstrumentIdentifierRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function postInstrumentIdentifierWithHttpInfo($postInstrumentIdentifierRequest, $profileId = null, $retrieveBinDetails = null)
    {
        // verify the required parameter 'postInstrumentIdentifierRequest' is set
        if ($postInstrumentIdentifierRequest === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $postInstrumentIdentifierRequest when calling postInstrumentIdentifier");
            throw new \InvalidArgumentException('Missing the required parameter $postInstrumentIdentifierRequest when calling postInstrumentIdentifier');
        }
        // parse inputs
        $resourcePath = "/tms/v1/instrumentidentifiers";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // query params
        if ($retrieveBinDetails !== null) {
            $queryParams['retrieveBinDetails'] = $this->apiClient->getSerializer()->toQueryValue($retrieveBinDetails);
        }
        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // body params
        $_tempBody = null;
        if (isset($postInstrumentIdentifierRequest)) {
            $_tempBody = $postInstrumentIdentifierRequest;
        }
        
        $sdkTracker = new \CyberSource\Utilities\Tracking\SdkTracker();
        $modelClassLocation = explode('\\', '\CyberSource\Model\PostInstrumentIdentifierRequest');

        $_tempBody = $sdkTracker->insertDeveloperIdTracker($_tempBody, end($modelClassLocation), $this->apiClient->merchantConfig->getRunEnvironment(), $this->apiClient->merchantConfig->getDefaultDeveloperId());

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "postInstrumentIdentifier,postInstrumentIdentifierWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : POST $resourcePath");
        self::$logger->debug("Query Parameters :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($queryParams));
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\PostInstrumentIdentifierRequest");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\PostInstrumentIdentifierRequest',
                '/tms/v1/instrumentidentifiers'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\PostInstrumentIdentifierRequest', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PostInstrumentIdentifierRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PostInstrumentIdentifierRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse409', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation postInstrumentIdentifierEnrollment
     *
     * Enroll an Instrument Identifier for Payment Network Token
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param \CyberSource\Model\PostInstrumentIdentifierEnrollmentRequest $postInstrumentIdentifierEnrollmentRequest Specify Enrollable Card details (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of void, HTTP status code, HTTP response headers (array of strings)
     */
    public function postInstrumentIdentifierEnrollment($instrumentIdentifierId, $postInstrumentIdentifierEnrollmentRequest, $profileId = null)
    {
        self::$logger->info('CALL TO METHOD postInstrumentIdentifierEnrollment STARTED');
        list($response, $statusCode, $httpHeader) = $this->postInstrumentIdentifierEnrollmentWithHttpInfo($instrumentIdentifierId, $postInstrumentIdentifierEnrollmentRequest, $profileId);
        self::$logger->info('CALL TO METHOD postInstrumentIdentifierEnrollment ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation postInstrumentIdentifierEnrollmentWithHttpInfo
     *
     * Enroll an Instrument Identifier for Payment Network Token
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param \CyberSource\Model\PostInstrumentIdentifierEnrollmentRequest $postInstrumentIdentifierEnrollmentRequest Specify Enrollable Card details (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postInstrumentIdentifierEnrollmentWithHttpInfo($instrumentIdentifierId, $postInstrumentIdentifierEnrollmentRequest, $profileId = null)
    {
        // verify the required parameter 'instrumentIdentifierId' is set
        if ($instrumentIdentifierId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $instrumentIdentifierId when calling postInstrumentIdentifierEnrollment");
            throw new \InvalidArgumentException('Missing the required parameter $instrumentIdentifierId when calling postInstrumentIdentifierEnrollment');
        }
        // verify the required parameter 'postInstrumentIdentifierEnrollmentRequest' is set
        if ($postInstrumentIdentifierEnrollmentRequest === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $postInstrumentIdentifierEnrollmentRequest when calling postInstrumentIdentifierEnrollment");
            throw new \InvalidArgumentException('Missing the required parameter $postInstrumentIdentifierEnrollmentRequest when calling postInstrumentIdentifierEnrollment');
        }
        // parse inputs
        $resourcePath = "/tms/v1/instrumentidentifiers/{instrumentIdentifierId}/enrollment";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // path params
        if ($instrumentIdentifierId !== null) {
            $resourcePath = str_replace(
                "{" . "instrumentIdentifierId" . "}",
                $this->apiClient->getSerializer()->toPathValue($instrumentIdentifierId),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($postInstrumentIdentifierEnrollmentRequest)) {
            $_tempBody = $postInstrumentIdentifierEnrollmentRequest;
        }
        
        $sdkTracker = new \CyberSource\Utilities\Tracking\SdkTracker();
        $modelClassLocation = explode('\\', '\CyberSource\Model\PostInstrumentIdentifierEnrollmentRequest');

        $_tempBody = $sdkTracker->insertDeveloperIdTracker($_tempBody, end($modelClassLocation), $this->apiClient->merchantConfig->getRunEnvironment(), $this->apiClient->merchantConfig->getDefaultDeveloperId());

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "postInstrumentIdentifierEnrollment,postInstrumentIdentifierEnrollmentWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : POST $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : null");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/tms/v1/instrumentidentifiers/{instrumentIdentifierId}/enrollment'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$response, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 424:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }
}
