<?php
/**
 * SubscriptionsFollowOnsApi
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Api;

use \CyberSource\ApiClient;
use \CyberSource\ApiException;
use \CyberSource\Configuration;
use \CyberSource\ObjectSerializer;
use \CyberSource\Logging\LogFactory as LogFactory;
use \CyberSource\Authentication\Util\MLEUtility;
use \CyberSource\Utilities\MultipartHelpers\MultipartHelper;
use \Exception;

/**
 * SubscriptionsFollowOnsApi Class Doc Comment
 *
 * @category Class
 * @package  CyberSource
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SubscriptionsFollowOnsApi
{
    private static $logger = null;
    
    /**
     * API Client
     *
     * @var \CyberSource\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \CyberSource\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\CyberSource\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;

        if (self::$logger === null) {
            self::$logger = (new LogFactory())->getLogger(\CyberSource\Utilities\Helpers\ClassHelper::getClassName(get_class($this)), $apiClient->merchantConfig->getLogConfiguration());
        }
    }

    /**
     * Get API client
     *
     * @return \CyberSource\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \CyberSource\ApiClient $apiClient set the API client
     *
     * @return SubscriptionsFollowOnsApi
     */
    public function setApiClient(\CyberSource\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createFollowOnSubscription
     *
     * Create a Follow-On Subscription
     *
     * @param string $requestId Request Id of an existing successful Transaction (required)
     * @param \CyberSource\Model\CreateSubscriptionRequest1 $createSubscriptionRequest  (required)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\CreateSubscriptionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createFollowOnSubscription($requestId, $createSubscriptionRequest)
    {
        self::$logger->info('CALL TO METHOD createFollowOnSubscription STARTED');
        list($response, $statusCode, $httpHeader) = $this->createFollowOnSubscriptionWithHttpInfo($requestId, $createSubscriptionRequest);
        self::$logger->info('CALL TO METHOD createFollowOnSubscription ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation createFollowOnSubscriptionWithHttpInfo
     *
     * Create a Follow-On Subscription
     *
     * @param string $requestId Request Id of an existing successful Transaction (required)
     * @param \CyberSource\Model\CreateSubscriptionRequest1 $createSubscriptionRequest  (required)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\CreateSubscriptionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createFollowOnSubscriptionWithHttpInfo($requestId, $createSubscriptionRequest)
    {
        // verify the required parameter 'requestId' is set
        if ($requestId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $requestId when calling createFollowOnSubscription");
            throw new \InvalidArgumentException('Missing the required parameter $requestId when calling createFollowOnSubscription');
        }
        // verify the required parameter 'createSubscriptionRequest' is set
        if ($createSubscriptionRequest === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $createSubscriptionRequest when calling createFollowOnSubscription");
            throw new \InvalidArgumentException('Missing the required parameter $createSubscriptionRequest when calling createFollowOnSubscription');
        }
        // parse inputs
        $resourcePath = "/rbs/v1/subscriptions/follow-ons/{requestId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'application/hal+json', 'application/json;charset=utf-8', 'application/hal+json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // path params
        if ($requestId !== null) {
            $resourcePath = str_replace(
                "{" . "requestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($requestId),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($createSubscriptionRequest)) {
            $_tempBody = $createSubscriptionRequest;
        }
        
        $sdkTracker = new \CyberSource\Utilities\Tracking\SdkTracker();
        $modelClassLocation = explode('\\', '\CyberSource\Model\CreateSubscriptionRequest1');

        $_tempBody = $sdkTracker->insertDeveloperIdTracker($_tempBody, end($modelClassLocation), $this->apiClient->merchantConfig->getRunEnvironment(), $this->apiClient->merchantConfig->getDefaultDeveloperId());

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "createFollowOnSubscription,createFollowOnSubscriptionWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : POST $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\CreateSubscriptionResponse");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\CreateSubscriptionResponse',
                '/rbs/v1/subscriptions/follow-ons/{requestId}'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\CreateSubscriptionResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\CreateSubscriptionResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse4005', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PtsV2PaymentsPost502Response', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation getFollowOnSubscription
     *
     * Get a Follow-On Subscription
     *
     * @param string $requestId Request Id of an existing successful Transaction (required)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\GetSubscriptionResponse1, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFollowOnSubscription($requestId)
    {
        self::$logger->info('CALL TO METHOD getFollowOnSubscription STARTED');
        list($response, $statusCode, $httpHeader) = $this->getFollowOnSubscriptionWithHttpInfo($requestId);
        self::$logger->info('CALL TO METHOD getFollowOnSubscription ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation getFollowOnSubscriptionWithHttpInfo
     *
     * Get a Follow-On Subscription
     *
     * @param string $requestId Request Id of an existing successful Transaction (required)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\GetSubscriptionResponse1, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFollowOnSubscriptionWithHttpInfo($requestId)
    {
        // verify the required parameter 'requestId' is set
        if ($requestId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $requestId when calling getFollowOnSubscription");
            throw new \InvalidArgumentException('Missing the required parameter $requestId when calling getFollowOnSubscription');
        }
        // parse inputs
        $resourcePath = "/rbs/v1/subscriptions/follow-ons/{requestId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'application/hal+json', 'application/json;charset=utf-8', 'application/hal+json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // path params
        if ($requestId !== null) {
            $resourcePath = str_replace(
                "{" . "requestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($requestId),
                $resourcePath
            );
        }
        if ('GET' == 'POST') {
            $_tempBody = '{}';
        }

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "getFollowOnSubscription,getFollowOnSubscriptionWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : GET $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\GetSubscriptionResponse1");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\GetSubscriptionResponse1',
                '/rbs/v1/subscriptions/follow-ons/{requestId}'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\GetSubscriptionResponse1', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\GetSubscriptionResponse1', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse4005', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse404', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\PtsV2PaymentsPost502Response', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }
}
