<?php
/**
 * TokenApi
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Api;

use \CyberSource\ApiClient;
use \CyberSource\ApiException;
use \CyberSource\Configuration;
use \CyberSource\ObjectSerializer;
use \CyberSource\Logging\LogFactory as LogFactory;
use \CyberSource\Authentication\Util\MLEUtility;
use \CyberSource\Utilities\MultipartHelpers\MultipartHelper;
use \Exception;

/**
 * TokenApi Class Doc Comment
 *
 * @category Class
 * @package  CyberSource
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TokenApi
{
    private static $logger = null;
    
    /**
     * API Client
     *
     * @var \CyberSource\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \CyberSource\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\CyberSource\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;

        if (self::$logger === null) {
            self::$logger = (new LogFactory())->getLogger(\CyberSource\Utilities\Helpers\ClassHelper::getClassName(get_class($this)), $apiClient->merchantConfig->getLogConfiguration());
        }
    }

    /**
     * Get API client
     *
     * @return \CyberSource\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \CyberSource\ApiClient $apiClient set the API client
     *
     * @return TokenApi
     */
    public function setApiClient(\CyberSource\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation getCardArtAsset
     *
     * Retrieve Card Art
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param string $tokenProvider The token provider. (required)
     * @param string $assetType The type of asset. (required)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\InlineResponse200, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCardArtAsset($instrumentIdentifierId, $tokenProvider, $assetType)
    {
        self::$logger->info('CALL TO METHOD getCardArtAsset STARTED');
        list($response, $statusCode, $httpHeader) = $this->getCardArtAssetWithHttpInfo($instrumentIdentifierId, $tokenProvider, $assetType);
        self::$logger->info('CALL TO METHOD getCardArtAsset ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation getCardArtAssetWithHttpInfo
     *
     * Retrieve Card Art
     *
     * @param string $instrumentIdentifierId The Id of an Instrument Identifier. (required)
     * @param string $tokenProvider The token provider. (required)
     * @param string $assetType The type of asset. (required)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of \CyberSource\Model\InlineResponse200, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCardArtAssetWithHttpInfo($instrumentIdentifierId, $tokenProvider, $assetType)
    {
        // verify the required parameter 'instrumentIdentifierId' is set
        if ($instrumentIdentifierId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $instrumentIdentifierId when calling getCardArtAsset");
            throw new \InvalidArgumentException('Missing the required parameter $instrumentIdentifierId when calling getCardArtAsset');
        }
        // verify the required parameter 'tokenProvider' is set
        if ($tokenProvider === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $tokenProvider when calling getCardArtAsset");
            throw new \InvalidArgumentException('Missing the required parameter $tokenProvider when calling getCardArtAsset');
        }
        // verify the required parameter 'assetType' is set
        if ($assetType === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $assetType when calling getCardArtAsset");
            throw new \InvalidArgumentException('Missing the required parameter $assetType when calling getCardArtAsset');
        }
        // parse inputs
        $resourcePath = "/tms/v2/tokens/{instrumentIdentifierId}/{tokenProvider}/assets/{assetType}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // path params
        if ($instrumentIdentifierId !== null) {
            $resourcePath = str_replace(
                "{" . "instrumentIdentifierId" . "}",
                $this->apiClient->getSerializer()->toPathValue($instrumentIdentifierId),
                $resourcePath
            );
        }
        // path params
        if ($tokenProvider !== null) {
            $resourcePath = str_replace(
                "{" . "tokenProvider" . "}",
                $this->apiClient->getSerializer()->toPathValue($tokenProvider),
                $resourcePath
            );
        }
        // path params
        if ($assetType !== null) {
            $resourcePath = str_replace(
                "{" . "assetType" . "}",
                $this->apiClient->getSerializer()->toPathValue($assetType),
                $resourcePath
            );
        }
        if ('GET' == 'POST') {
            $_tempBody = '{}';
        }

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "getCardArtAsset,getCardArtAssetWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : GET $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : \CyberSource\Model\InlineResponse200");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\CyberSource\Model\InlineResponse200',
                '/tms/v2/tokens/{instrumentIdentifierId}/{tokenProvider}/assets/{assetType}'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, '\CyberSource\Model\InlineResponse200', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse200', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }

    /**
     * Operation postTokenPaymentCredentials
     *
     * Generate Payment Credentials for a TMS Token
     *
     * @param string $tokenId The Id of a token representing a Customer, Payment Instrument or Instrument Identifier. (required)
     * @param \CyberSource\Model\PostPaymentCredentialsRequest $postPaymentCredentialsRequest  (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTokenPaymentCredentials($tokenId, $postPaymentCredentialsRequest, $profileId = null)
    {
        self::$logger->info('CALL TO METHOD postTokenPaymentCredentials STARTED');
        list($response, $statusCode, $httpHeader) = $this->postTokenPaymentCredentialsWithHttpInfo($tokenId, $postPaymentCredentialsRequest, $profileId);
        self::$logger->info('CALL TO METHOD postTokenPaymentCredentials ENDED');
        self::$logger->close();
        return [$response, $statusCode, $httpHeader];
    }

    /**
     * Operation postTokenPaymentCredentialsWithHttpInfo
     *
     * Generate Payment Credentials for a TMS Token
     *
     * @param string $tokenId The Id of a token representing a Customer, Payment Instrument or Instrument Identifier. (required)
     * @param \CyberSource\Model\PostPaymentCredentialsRequest $postPaymentCredentialsRequest  (required)
     * @param string $profileId The Id of a profile containing user specific TMS configuration. (optional)
     * @throws \CyberSource\ApiException on non-2xx response
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTokenPaymentCredentialsWithHttpInfo($tokenId, $postPaymentCredentialsRequest, $profileId = null)
    {
        // verify the required parameter 'tokenId' is set
        if ($tokenId === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $tokenId when calling postTokenPaymentCredentials");
            throw new \InvalidArgumentException('Missing the required parameter $tokenId when calling postTokenPaymentCredentials');
        }
        // verify the required parameter 'postPaymentCredentialsRequest' is set
        if ($postPaymentCredentialsRequest === null) {
            self::$logger->error("InvalidArgumentException : Missing the required parameter $postPaymentCredentialsRequest when calling postTokenPaymentCredentials");
            throw new \InvalidArgumentException('Missing the required parameter $postPaymentCredentialsRequest when calling postTokenPaymentCredentials');
        }
        // parse inputs
        $resourcePath = "/tms/v2/tokens/{tokenId}/payment-credentials";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/jose;charset=utf-8']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json;charset=utf-8']);

        // header params
        if ($profileId !== null) {
            $headerParams['profile-id'] = $this->apiClient->getSerializer()->toHeaderValue($profileId);
        }
        // path params
        if ($tokenId !== null) {
            $resourcePath = str_replace(
                "{" . "tokenId" . "}",
                $this->apiClient->getSerializer()->toPathValue($tokenId),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($postPaymentCredentialsRequest)) {
            $_tempBody = $postPaymentCredentialsRequest;
        }
        
        $sdkTracker = new \CyberSource\Utilities\Tracking\SdkTracker();
        $modelClassLocation = explode('\\', '\CyberSource\Model\PostPaymentCredentialsRequest');

        $_tempBody = $sdkTracker->insertDeveloperIdTracker($_tempBody, end($modelClassLocation), $this->apiClient->merchantConfig->getRunEnvironment(), $this->apiClient->merchantConfig->getDefaultDeveloperId());

        // for model (json/xml)
        if (isset($_tempBody) and count($formParams) <= 0) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = MultipartHelper::build_data_files($boundary, $formParams); // for HTTP post (form)
        }

        //MLE check and mle encryption for req body
        $isMLESupportedByCybsForApi = false;
        if (MLEUtility::checkIsMLEForAPI($this->apiClient->merchantConfig, $isMLESupportedByCybsForApi, "postTokenPaymentCredentials,postTokenPaymentCredentialsWithHttpInfo")) {
            try {
                $httpBody = MLEUtility::encryptRequestPayload($this->apiClient->merchantConfig, $httpBody);
            } catch (Exception $e) {
                self::$logger->error("Failed to encrypt request body:  $e");
                throw new ApiException("Failed to encrypt request body : " . $e->getMessage());
            }
        }

        
        // Logging
        self::$logger->debug("Resource : POST $resourcePath");
        if (isset($httpBody) and count($formParams) <= 0) {
            if ($this->apiClient->merchantConfig->getLogConfiguration()->isMaskingEnabled()) {
                $printHttpBody = \CyberSource\Utilities\Helpers\DataMasker::maskData($httpBody);
            } else {
                $printHttpBody = $httpBody;
            }
            
            self::$logger->debug("Body Parameter :\n" . $printHttpBody); 
        }

        self::$logger->debug("Return Type : string");
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/tms/v2/tokens/{tokenId}/payment-credentials'
            );
            
            self::$logger->debug("Response Headers :\n" . \CyberSource\Utilities\Helpers\ListHelper::toString($httpHeader));

            return [$this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse403', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse424', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse410', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\CyberSource\Model\InlineResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            self::$logger->error("ApiException : $e");
            throw $e;
        }
    }
}
