<?php
/**
 * CardProcessingConfigCommon
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * CardProcessingConfigCommon Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CardProcessingConfigCommon implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CardProcessingConfig_common';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'processors' => 'map[string,\CyberSource\Model\CardProcessingConfigCommonProcessors]',
        'amexVendorCode' => 'string',
        'defaultAuthTypeCode' => 'string',
        'masterCardAssignedId' => 'string',
        'enablePartialAuth' => 'bool',
        'merchantCategoryCode' => 'string',
        'sicCode' => 'string',
        'foodAndConsumerServiceId' => 'string',
        'enableSplitShipment' => 'bool',
        'enableInterchangeOptimization' => 'bool',
        'visaDelegatedAuthenticationId' => 'string',
        'creditCardRefundLimitPercent' => 'string',
        'businessCenterCreditCardRefundLimitPercent' => 'string',
        'allowCapturesGreaterThanAuthorizations' => 'bool',
        'enableDuplicateMerchantReferenceNumberBlocking' => 'bool',
        'domesticMerchantId' => 'bool',
        'processLevel3Data' => 'string',
        'subMerchantId' => 'string',
        'subMerchantBusinessName' => 'string',
        'preferCobadgedSecondaryBrand' => 'bool',
        'merchantDescriptorInformation' => '\CyberSource\Model\CardProcessingConfigCommonMerchantDescriptorInformation',
        'governmentControlled' => 'bool',
        'dropBillingInfo' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'processors' => null,
        'amexVendorCode' => null,
        'defaultAuthTypeCode' => null,
        'masterCardAssignedId' => null,
        'enablePartialAuth' => null,
        'merchantCategoryCode' => null,
        'sicCode' => null,
        'foodAndConsumerServiceId' => null,
        'enableSplitShipment' => null,
        'enableInterchangeOptimization' => null,
        'visaDelegatedAuthenticationId' => null,
        'creditCardRefundLimitPercent' => null,
        'businessCenterCreditCardRefundLimitPercent' => null,
        'allowCapturesGreaterThanAuthorizations' => null,
        'enableDuplicateMerchantReferenceNumberBlocking' => null,
        'domesticMerchantId' => null,
        'processLevel3Data' => null,
        'subMerchantId' => null,
        'subMerchantBusinessName' => null,
        'preferCobadgedSecondaryBrand' => null,
        'merchantDescriptorInformation' => null,
        'governmentControlled' => null,
        'dropBillingInfo' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'processors' => 'processors',
        'amexVendorCode' => 'amexVendorCode',
        'defaultAuthTypeCode' => 'defaultAuthTypeCode',
        'masterCardAssignedId' => 'masterCardAssignedId',
        'enablePartialAuth' => 'enablePartialAuth',
        'merchantCategoryCode' => 'merchantCategoryCode',
        'sicCode' => 'sicCode',
        'foodAndConsumerServiceId' => 'foodAndConsumerServiceId',
        'enableSplitShipment' => 'enableSplitShipment',
        'enableInterchangeOptimization' => 'enableInterchangeOptimization',
        'visaDelegatedAuthenticationId' => 'visaDelegatedAuthenticationId',
        'creditCardRefundLimitPercent' => 'creditCardRefundLimitPercent',
        'businessCenterCreditCardRefundLimitPercent' => 'businessCenterCreditCardRefundLimitPercent',
        'allowCapturesGreaterThanAuthorizations' => 'allowCapturesGreaterThanAuthorizations',
        'enableDuplicateMerchantReferenceNumberBlocking' => 'enableDuplicateMerchantReferenceNumberBlocking',
        'domesticMerchantId' => 'domesticMerchantId',
        'processLevel3Data' => 'processLevel3Data',
        'subMerchantId' => 'subMerchantId',
        'subMerchantBusinessName' => 'subMerchantBusinessName',
        'preferCobadgedSecondaryBrand' => 'preferCobadgedSecondaryBrand',
        'merchantDescriptorInformation' => 'merchantDescriptorInformation',
        'governmentControlled' => 'governmentControlled',
        'dropBillingInfo' => 'dropBillingInfo'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'processors' => 'setProcessors',
        'amexVendorCode' => 'setAmexVendorCode',
        'defaultAuthTypeCode' => 'setDefaultAuthTypeCode',
        'masterCardAssignedId' => 'setMasterCardAssignedId',
        'enablePartialAuth' => 'setEnablePartialAuth',
        'merchantCategoryCode' => 'setMerchantCategoryCode',
        'sicCode' => 'setSicCode',
        'foodAndConsumerServiceId' => 'setFoodAndConsumerServiceId',
        'enableSplitShipment' => 'setEnableSplitShipment',
        'enableInterchangeOptimization' => 'setEnableInterchangeOptimization',
        'visaDelegatedAuthenticationId' => 'setVisaDelegatedAuthenticationId',
        'creditCardRefundLimitPercent' => 'setCreditCardRefundLimitPercent',
        'businessCenterCreditCardRefundLimitPercent' => 'setBusinessCenterCreditCardRefundLimitPercent',
        'allowCapturesGreaterThanAuthorizations' => 'setAllowCapturesGreaterThanAuthorizations',
        'enableDuplicateMerchantReferenceNumberBlocking' => 'setEnableDuplicateMerchantReferenceNumberBlocking',
        'domesticMerchantId' => 'setDomesticMerchantId',
        'processLevel3Data' => 'setProcessLevel3Data',
        'subMerchantId' => 'setSubMerchantId',
        'subMerchantBusinessName' => 'setSubMerchantBusinessName',
        'preferCobadgedSecondaryBrand' => 'setPreferCobadgedSecondaryBrand',
        'merchantDescriptorInformation' => 'setMerchantDescriptorInformation',
        'governmentControlled' => 'setGovernmentControlled',
        'dropBillingInfo' => 'setDropBillingInfo'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'processors' => 'getProcessors',
        'amexVendorCode' => 'getAmexVendorCode',
        'defaultAuthTypeCode' => 'getDefaultAuthTypeCode',
        'masterCardAssignedId' => 'getMasterCardAssignedId',
        'enablePartialAuth' => 'getEnablePartialAuth',
        'merchantCategoryCode' => 'getMerchantCategoryCode',
        'sicCode' => 'getSicCode',
        'foodAndConsumerServiceId' => 'getFoodAndConsumerServiceId',
        'enableSplitShipment' => 'getEnableSplitShipment',
        'enableInterchangeOptimization' => 'getEnableInterchangeOptimization',
        'visaDelegatedAuthenticationId' => 'getVisaDelegatedAuthenticationId',
        'creditCardRefundLimitPercent' => 'getCreditCardRefundLimitPercent',
        'businessCenterCreditCardRefundLimitPercent' => 'getBusinessCenterCreditCardRefundLimitPercent',
        'allowCapturesGreaterThanAuthorizations' => 'getAllowCapturesGreaterThanAuthorizations',
        'enableDuplicateMerchantReferenceNumberBlocking' => 'getEnableDuplicateMerchantReferenceNumberBlocking',
        'domesticMerchantId' => 'getDomesticMerchantId',
        'processLevel3Data' => 'getProcessLevel3Data',
        'subMerchantId' => 'getSubMerchantId',
        'subMerchantBusinessName' => 'getSubMerchantBusinessName',
        'preferCobadgedSecondaryBrand' => 'getPreferCobadgedSecondaryBrand',
        'merchantDescriptorInformation' => 'getMerchantDescriptorInformation',
        'governmentControlled' => 'getGovernmentControlled',
        'dropBillingInfo' => 'getDropBillingInfo'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['processors'] = isset($data['processors']) ? $data['processors'] : null;
        $this->container['amexVendorCode'] = isset($data['amexVendorCode']) ? $data['amexVendorCode'] : null;
        $this->container['defaultAuthTypeCode'] = isset($data['defaultAuthTypeCode']) ? $data['defaultAuthTypeCode'] : null;
        $this->container['masterCardAssignedId'] = isset($data['masterCardAssignedId']) ? $data['masterCardAssignedId'] : null;
        $this->container['enablePartialAuth'] = isset($data['enablePartialAuth']) ? $data['enablePartialAuth'] : null;
        $this->container['merchantCategoryCode'] = isset($data['merchantCategoryCode']) ? $data['merchantCategoryCode'] : null;
        $this->container['sicCode'] = isset($data['sicCode']) ? $data['sicCode'] : null;
        $this->container['foodAndConsumerServiceId'] = isset($data['foodAndConsumerServiceId']) ? $data['foodAndConsumerServiceId'] : null;
        $this->container['enableSplitShipment'] = isset($data['enableSplitShipment']) ? $data['enableSplitShipment'] : null;
        $this->container['enableInterchangeOptimization'] = isset($data['enableInterchangeOptimization']) ? $data['enableInterchangeOptimization'] : null;
        $this->container['visaDelegatedAuthenticationId'] = isset($data['visaDelegatedAuthenticationId']) ? $data['visaDelegatedAuthenticationId'] : null;
        $this->container['creditCardRefundLimitPercent'] = isset($data['creditCardRefundLimitPercent']) ? $data['creditCardRefundLimitPercent'] : null;
        $this->container['businessCenterCreditCardRefundLimitPercent'] = isset($data['businessCenterCreditCardRefundLimitPercent']) ? $data['businessCenterCreditCardRefundLimitPercent'] : null;
        $this->container['allowCapturesGreaterThanAuthorizations'] = isset($data['allowCapturesGreaterThanAuthorizations']) ? $data['allowCapturesGreaterThanAuthorizations'] : null;
        $this->container['enableDuplicateMerchantReferenceNumberBlocking'] = isset($data['enableDuplicateMerchantReferenceNumberBlocking']) ? $data['enableDuplicateMerchantReferenceNumberBlocking'] : null;
        $this->container['domesticMerchantId'] = isset($data['domesticMerchantId']) ? $data['domesticMerchantId'] : null;
        $this->container['processLevel3Data'] = isset($data['processLevel3Data']) ? $data['processLevel3Data'] : null;
        $this->container['subMerchantId'] = isset($data['subMerchantId']) ? $data['subMerchantId'] : null;
        $this->container['subMerchantBusinessName'] = isset($data['subMerchantBusinessName']) ? $data['subMerchantBusinessName'] : null;
        $this->container['preferCobadgedSecondaryBrand'] = isset($data['preferCobadgedSecondaryBrand']) ? $data['preferCobadgedSecondaryBrand'] : null;
        $this->container['merchantDescriptorInformation'] = isset($data['merchantDescriptorInformation']) ? $data['merchantDescriptorInformation'] : null;
        $this->container['governmentControlled'] = isset($data['governmentControlled']) ? $data['governmentControlled'] : null;
        $this->container['dropBillingInfo'] = isset($data['dropBillingInfo']) ? $data['dropBillingInfo'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets processors
     * @return map[string,\CyberSource\Model\CardProcessingConfigCommonProcessors]
     */
    public function getProcessors()
    {
        return $this->container['processors'];
    }

    /**
     * Sets processors
     * @param map[string,\CyberSource\Model\CardProcessingConfigCommonProcessors] $processors e.g. * amexdirect * barclays2 * CUP * EFTPOS * fdiglobal * gpngsapv3 * gpx * smartfdc * tsys * vero * VPC  For VPC, CUP and EFTPOS processors, replace the processor name from VPC or CUP or EFTPOS to the actual processor name in the sample request. e.g. replace VPC with &lt;your vpc processor&gt;
     * @return $this
     */
    public function setProcessors($processors)
    {
        $this->container['processors'] = $processors;

        return $this;
    }

    /**
     * Gets amexVendorCode
     * @return string
     */
    public function getAmexVendorCode()
    {
        return $this->container['amexVendorCode'];
    }

    /**
     * Sets amexVendorCode
     * @param string $amexVendorCode Vendor code assigned by American Express. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setAmexVendorCode($amexVendorCode)
    {
        $this->container['amexVendorCode'] = $amexVendorCode;

        return $this;
    }

    /**
     * Gets defaultAuthTypeCode
     * @return string
     */
    public function getDefaultAuthTypeCode()
    {
        return $this->container['defaultAuthTypeCode'];
    }

    /**
     * Sets defaultAuthTypeCode
     * @param string $defaultAuthTypeCode Authorization Finality indicator. Please note that the input can be in small case or capitals but response is in small case as of now. It will be made capitals everywhere in the next version. Applicable for Elavon Americas (elavonamericas), TSYS (tsys), Barclays (barclays2), Streamline (streamline2), Six (six), Barclays HISO (barclayshiso), GPN (gpn), FDI Global (fdiglobal), GPX (gpx), Paymentech Tampa (paymentechtampa), FDC Nashville (smartfdc), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>FINAL</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td><td>FINAL</td></tr> </table>   Possible values: - PRE - FINAL - UNDEFINED
     * @return $this
     */
    public function setDefaultAuthTypeCode($defaultAuthTypeCode)
    {
        $this->container['defaultAuthTypeCode'] = $defaultAuthTypeCode;

        return $this;
    }

    /**
     * Gets masterCardAssignedId
     * @return string
     */
    public function getMasterCardAssignedId()
    {
        return $this->container['masterCardAssignedId'];
    }

    /**
     * Sets masterCardAssignedId
     * @param string $masterCardAssignedId MAID aka MasterCard assigned ID, MasterCard equivalent of Merchant Verification Value by Visa. Applicable for VPC, GPX (gpx) and FDI Global (fdiglobal) processors.
     * @return $this
     */
    public function setMasterCardAssignedId($masterCardAssignedId)
    {
        $this->container['masterCardAssignedId'] = $masterCardAssignedId;

        return $this;
    }

    /**
     * Gets enablePartialAuth
     * @return bool
     */
    public function getEnablePartialAuth()
    {
        return $this->container['enablePartialAuth'];
    }

    /**
     * Sets enablePartialAuth
     * @param bool $enablePartialAuth Allow merchants to accept partial authorization approvals. Applicable for Elavon Americas (elavonamericas), VPC, GPX (gpx), FDI Global (fdiglobal), FDC Nashville (smartfdc), GPN (gpn), TSYS (tsys), American Express Direct (amexdirect), Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setEnablePartialAuth($enablePartialAuth)
    {
        $this->container['enablePartialAuth'] = $enablePartialAuth;

        return $this;
    }

    /**
     * Gets merchantCategoryCode
     * @return string
     */
    public function getMerchantCategoryCode()
    {
        return $this->container['merchantCategoryCode'];
    }

    /**
     * Sets merchantCategoryCode
     * @param string $merchantCategoryCode Indicates type of business product or service of the merchant. Applicable for Chase Paymentech Salem (chasepaymentechsalem), FDI Global (fdiglobal), RUPAY, Elavon Americas (elavonamericas), American Express Direct (amexdirect), CMCIC (cmcic), GPX (gpx), VPC, TSYS (tsys), EFTPOS, CUP, Paymentech Tampa (paymentechtampa), CB2A, Barclays (barclays2), Prisma (prisma) and GPN (gpn) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> </table>
     * @return $this
     */
    public function setMerchantCategoryCode($merchantCategoryCode)
    {
        $this->container['merchantCategoryCode'] = $merchantCategoryCode;

        return $this;
    }

    /**
     * Gets sicCode
     * @return string
     */
    public function getSicCode()
    {
        return $this->container['sicCode'];
    }

    /**
     * Sets sicCode
     * @param string $sicCode The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.
     * @return $this
     */
    public function setSicCode($sicCode)
    {
        $this->container['sicCode'] = $sicCode;

        return $this;
    }

    /**
     * Gets foodAndConsumerServiceId
     * @return string
     */
    public function getFoodAndConsumerServiceId()
    {
        return $this->container['foodAndConsumerServiceId'];
    }

    /**
     * Sets foodAndConsumerServiceId
     * @param string $foodAndConsumerServiceId Food and Consumer Service ID. Identifies the merchant as being certified and approved to accept Food Stamps. Applicable for GPX (gpx) processor.
     * @return $this
     */
    public function setFoodAndConsumerServiceId($foodAndConsumerServiceId)
    {
        $this->container['foodAndConsumerServiceId'] = $foodAndConsumerServiceId;

        return $this;
    }

    /**
     * Gets enableSplitShipment
     * @return bool
     */
    public function getEnableSplitShipment()
    {
        return $this->container['enableSplitShipment'];
    }

    /**
     * Sets enableSplitShipment
     * @param bool $enableSplitShipment Enables you to split an order into multiple shipments with multiple captures. This feature is provided by CyberSource and supports three different scenarios:  * multiple authorizations * multiple captures * multiple authorizations with multiple captures  Applicable for VPC processors.
     * @return $this
     */
    public function setEnableSplitShipment($enableSplitShipment)
    {
        $this->container['enableSplitShipment'] = $enableSplitShipment;

        return $this;
    }

    /**
     * Gets enableInterchangeOptimization
     * @return bool
     */
    public function getEnableInterchangeOptimization()
    {
        return $this->container['enableInterchangeOptimization'];
    }

    /**
     * Sets enableInterchangeOptimization
     * @param bool $enableInterchangeOptimization Reduces your interchange fees by using automatic authorization refresh and automatic partial authorization reversal. Applicable for VPC processors.
     * @return $this
     */
    public function setEnableInterchangeOptimization($enableInterchangeOptimization)
    {
        $this->container['enableInterchangeOptimization'] = $enableInterchangeOptimization;

        return $this;
    }

    /**
     * Gets visaDelegatedAuthenticationId
     * @return string
     */
    public function getVisaDelegatedAuthenticationId()
    {
        return $this->container['visaDelegatedAuthenticationId'];
    }

    /**
     * Sets visaDelegatedAuthenticationId
     * @param string $visaDelegatedAuthenticationId Identifier provided to merchants who opt for Visa's delegated authorization program. Applicable for VPC processors.
     * @return $this
     */
    public function setVisaDelegatedAuthenticationId($visaDelegatedAuthenticationId)
    {
        $this->container['visaDelegatedAuthenticationId'] = $visaDelegatedAuthenticationId;

        return $this;
    }

    /**
     * Gets creditCardRefundLimitPercent
     * @return string
     */
    public function getCreditCardRefundLimitPercent()
    {
        return $this->container['creditCardRefundLimitPercent'];
    }

    /**
     * Sets creditCardRefundLimitPercent
     * @param string $creditCardRefundLimitPercent Blocks over-refunds when the aggregated refund amount is higher than the percentage set for this field. Applicable for GPX (gpx), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.
     * @return $this
     */
    public function setCreditCardRefundLimitPercent($creditCardRefundLimitPercent)
    {
        $this->container['creditCardRefundLimitPercent'] = $creditCardRefundLimitPercent;

        return $this;
    }

    /**
     * Gets businessCenterCreditCardRefundLimitPercent
     * @return string
     */
    public function getBusinessCenterCreditCardRefundLimitPercent()
    {
        return $this->container['businessCenterCreditCardRefundLimitPercent'];
    }

    /**
     * Sets businessCenterCreditCardRefundLimitPercent
     * @param string $businessCenterCreditCardRefundLimitPercent Limits refunds to the percentage set in this field. Applicable for GPX (gpx) and VPC processors.
     * @return $this
     */
    public function setBusinessCenterCreditCardRefundLimitPercent($businessCenterCreditCardRefundLimitPercent)
    {
        $this->container['businessCenterCreditCardRefundLimitPercent'] = $businessCenterCreditCardRefundLimitPercent;

        return $this;
    }

    /**
     * Gets allowCapturesGreaterThanAuthorizations
     * @return bool
     */
    public function getAllowCapturesGreaterThanAuthorizations()
    {
        return $this->container['allowCapturesGreaterThanAuthorizations'];
    }

    /**
     * Sets allowCapturesGreaterThanAuthorizations
     * @param bool $allowCapturesGreaterThanAuthorizations Enables this merchant account to capture amounts greater than the authorization amount. Applicable for GPX (gpx), VPC, Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.
     * @return $this
     */
    public function setAllowCapturesGreaterThanAuthorizations($allowCapturesGreaterThanAuthorizations)
    {
        $this->container['allowCapturesGreaterThanAuthorizations'] = $allowCapturesGreaterThanAuthorizations;

        return $this;
    }

    /**
     * Gets enableDuplicateMerchantReferenceNumberBlocking
     * @return bool
     */
    public function getEnableDuplicateMerchantReferenceNumberBlocking()
    {
        return $this->container['enableDuplicateMerchantReferenceNumberBlocking'];
    }

    /**
     * Sets enableDuplicateMerchantReferenceNumberBlocking
     * @param bool $enableDuplicateMerchantReferenceNumberBlocking Helps prevent duplicate transactions. Applicable for VPC, GPX (gpx) and Chase Paymentech Salem (chasepaymentechsalem) processors.
     * @return $this
     */
    public function setEnableDuplicateMerchantReferenceNumberBlocking($enableDuplicateMerchantReferenceNumberBlocking)
    {
        $this->container['enableDuplicateMerchantReferenceNumberBlocking'] = $enableDuplicateMerchantReferenceNumberBlocking;

        return $this;
    }

    /**
     * Gets domesticMerchantId
     * @return bool
     */
    public function getDomesticMerchantId()
    {
        return $this->container['domesticMerchantId'];
    }

    /**
     * Sets domesticMerchantId
     * @param bool $domesticMerchantId This is a local merchant ID used by merchants in addition to the conventional merchant ID. This value is sent to the issuer. Applicable for VPC and Prisma (prisma) processors.
     * @return $this
     */
    public function setDomesticMerchantId($domesticMerchantId)
    {
        $this->container['domesticMerchantId'] = $domesticMerchantId;

        return $this;
    }

    /**
     * Gets processLevel3Data
     * @return string
     */
    public function getProcessLevel3Data()
    {
        return $this->container['processLevel3Data'];
    }

    /**
     * Sets processLevel3Data
     * @param string $processLevel3Data Indicates whether merchant processes Level 3 transactions. Applicable for TSYS (tsys), Barclays (barclays2), Paymentech Tampa (paymentechtampa), FDI Global (fdiglobal), Elavon Americas (elavonamericas) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setProcessLevel3Data($processLevel3Data)
    {
        $this->container['processLevel3Data'] = $processLevel3Data;

        return $this;
    }

    /**
     * Gets subMerchantId
     * @return string
     */
    public function getSubMerchantId()
    {
        return $this->container['subMerchantId'];
    }

    /**
     * Sets subMerchantId
     * @param string $subMerchantId The ID assigned to the sub-merchant. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>20</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table>
     * @return $this
     */
    public function setSubMerchantId($subMerchantId)
    {
        $this->container['subMerchantId'] = $subMerchantId;

        return $this;
    }

    /**
     * Gets subMerchantBusinessName
     * @return string
     */
    public function getSubMerchantBusinessName()
    {
        return $this->container['subMerchantBusinessName'];
    }

    /**
     * Sets subMerchantBusinessName
     * @param string $subMerchantBusinessName Sub-merchant's business name. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>37</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table>
     * @return $this
     */
    public function setSubMerchantBusinessName($subMerchantBusinessName)
    {
        $this->container['subMerchantBusinessName'] = $subMerchantBusinessName;

        return $this;
    }

    /**
     * Gets preferCobadgedSecondaryBrand
     * @return bool
     */
    public function getPreferCobadgedSecondaryBrand()
    {
        return $this->container['preferCobadgedSecondaryBrand'];
    }

    /**
     * Sets preferCobadgedSecondaryBrand
     * @param bool $preferCobadgedSecondaryBrand It denotes merchant's preference on secondary brand for routing in case of co-branded cards. Applicable for EFTPOS processors.
     * @return $this
     */
    public function setPreferCobadgedSecondaryBrand($preferCobadgedSecondaryBrand)
    {
        $this->container['preferCobadgedSecondaryBrand'] = $preferCobadgedSecondaryBrand;

        return $this;
    }

    /**
     * Gets merchantDescriptorInformation
     * @return \CyberSource\Model\CardProcessingConfigCommonMerchantDescriptorInformation
     */
    public function getMerchantDescriptorInformation()
    {
        return $this->container['merchantDescriptorInformation'];
    }

    /**
     * Sets merchantDescriptorInformation
     * @param \CyberSource\Model\CardProcessingConfigCommonMerchantDescriptorInformation $merchantDescriptorInformation
     * @return $this
     */
    public function setMerchantDescriptorInformation($merchantDescriptorInformation)
    {
        $this->container['merchantDescriptorInformation'] = $merchantDescriptorInformation;

        return $this;
    }

    /**
     * Gets governmentControlled
     * @return bool
     */
    public function getGovernmentControlled()
    {
        return $this->container['governmentControlled'];
    }

    /**
     * Sets governmentControlled
     * @param bool $governmentControlled Indicates whether the merchant is government controlled. Applicable for VPC processors.
     * @return $this
     */
    public function setGovernmentControlled($governmentControlled)
    {
        $this->container['governmentControlled'] = $governmentControlled;

        return $this;
    }

    /**
     * Gets dropBillingInfo
     * @return bool
     */
    public function getDropBillingInfo()
    {
        return $this->container['dropBillingInfo'];
    }

    /**
     * Sets dropBillingInfo
     * @param bool $dropBillingInfo This field is used to indicate whether the merchant wants to drop the billing information from the request. If this field is set to true, then the billing information will be dropped from the request. If this field is set to false, then the billing information will be sent in the request.
     * @return $this
     */
    public function setDropBillingInfo($dropBillingInfo)
    {
        $this->container['dropBillingInfo'] = $dropBillingInfo;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


