<?php
/**
 * CardProcessingConfigCommonProcessors
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * CardProcessingConfigCommonProcessors Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CardProcessingConfigCommonProcessors implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CardProcessingConfig_common_processors';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'batchGroup' => 'string',
        'businessApplicationId' => 'string',
        'merchantVerificationValue' => 'string',
        'abaNumber' => 'string',
        'acquirer' => '\CyberSource\Model\CardProcessingConfigCommonAcquirer',
        'merchantId' => 'string',
        'terminalId' => 'string',
        'paymentTypes' => 'map[string,\CyberSource\Model\CardProcessingConfigCommonPaymentTypes]',
        'currencies' => 'map[string,\CyberSource\Model\CardProcessingConfigCommonCurrencies1]',
        'visaAggregatorId' => 'string',
        'amexAggregatorId' => 'string',
        'masterCardAggregatorId' => 'string',
        'sicCode' => 'string',
        'allowMultipleBills' => 'bool',
        'allowMerchantDescriptorOverride' => 'bool',
        'enhancedData' => 'string',
        'fireSafetyIndicator' => 'bool',
        'quasiCash' => 'bool',
        'acquirerMerchantId' => 'string',
        'avsFormat' => 'string',
        'enableLongTransRefNo' => 'bool',
        'enableLevel2' => 'bool',
        'enableMultipleTransactionAdviceAddendum' => 'bool',
        'amexTransactionAdviceAddendum1' => 'string',
        'enableMultiLineItems' => 'bool',
        'enableTransactionReferenceNumber' => 'bool',
        'enableAutoAuthReversalAfterVoid' => 'bool',
        'enableExpresspayPanTranslation' => 'bool',
        'enableCreditAuth' => 'bool',
        'industryCode' => 'string',
        'sendAmexLevel2Data' => 'bool',
        'softDescriptorType' => 'string',
        'vitalNumber' => 'string',
        'bankNumber' => 'string',
        'chainNumber' => 'string',
        'merchantBinNumber' => 'string',
        'merchantLocationNumber' => 'string',
        'storeID' => 'string',
        'travelAgencyCode' => 'string',
        'travelAgencyName' => 'string',
        'settlementCurrency' => 'string',
        'enableLeastCostRouting' => 'bool',
        'enableCVVResponseIndicator' => 'bool',
        'enableMultiCurrencyProcessing' => 'string',
        'enablePosNetworkSwitching' => 'bool',
        'enableDynamicCurrencyConversion' => 'bool',
        'merchantTier' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'batchGroup' => null,
        'businessApplicationId' => null,
        'merchantVerificationValue' => null,
        'abaNumber' => null,
        'acquirer' => null,
        'merchantId' => null,
        'terminalId' => null,
        'paymentTypes' => null,
        'currencies' => null,
        'visaAggregatorId' => null,
        'amexAggregatorId' => null,
        'masterCardAggregatorId' => null,
        'sicCode' => null,
        'allowMultipleBills' => null,
        'allowMerchantDescriptorOverride' => null,
        'enhancedData' => null,
        'fireSafetyIndicator' => null,
        'quasiCash' => null,
        'acquirerMerchantId' => null,
        'avsFormat' => null,
        'enableLongTransRefNo' => null,
        'enableLevel2' => null,
        'enableMultipleTransactionAdviceAddendum' => null,
        'amexTransactionAdviceAddendum1' => null,
        'enableMultiLineItems' => null,
        'enableTransactionReferenceNumber' => null,
        'enableAutoAuthReversalAfterVoid' => null,
        'enableExpresspayPanTranslation' => null,
        'enableCreditAuth' => null,
        'industryCode' => null,
        'sendAmexLevel2Data' => null,
        'softDescriptorType' => null,
        'vitalNumber' => null,
        'bankNumber' => null,
        'chainNumber' => null,
        'merchantBinNumber' => null,
        'merchantLocationNumber' => null,
        'storeID' => null,
        'travelAgencyCode' => null,
        'travelAgencyName' => null,
        'settlementCurrency' => null,
        'enableLeastCostRouting' => null,
        'enableCVVResponseIndicator' => null,
        'enableMultiCurrencyProcessing' => null,
        'enablePosNetworkSwitching' => null,
        'enableDynamicCurrencyConversion' => null,
        'merchantTier' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'batchGroup' => 'batchGroup',
        'businessApplicationId' => 'businessApplicationId',
        'merchantVerificationValue' => 'merchantVerificationValue',
        'abaNumber' => 'abaNumber',
        'acquirer' => 'acquirer',
        'merchantId' => 'merchantId',
        'terminalId' => 'terminalId',
        'paymentTypes' => 'paymentTypes',
        'currencies' => 'currencies',
        'visaAggregatorId' => 'visaAggregatorId',
        'amexAggregatorId' => 'amexAggregatorId',
        'masterCardAggregatorId' => 'masterCardAggregatorId',
        'sicCode' => 'sicCode',
        'allowMultipleBills' => 'allowMultipleBills',
        'allowMerchantDescriptorOverride' => 'allowMerchantDescriptorOverride',
        'enhancedData' => 'enhancedData',
        'fireSafetyIndicator' => 'fireSafetyIndicator',
        'quasiCash' => 'quasiCash',
        'acquirerMerchantId' => 'acquirerMerchantId',
        'avsFormat' => 'avsFormat',
        'enableLongTransRefNo' => 'enableLongTransRefNo',
        'enableLevel2' => 'enableLevel2',
        'enableMultipleTransactionAdviceAddendum' => 'enableMultipleTransactionAdviceAddendum',
        'amexTransactionAdviceAddendum1' => 'amexTransactionAdviceAddendum1',
        'enableMultiLineItems' => 'enableMultiLineItems',
        'enableTransactionReferenceNumber' => 'enableTransactionReferenceNumber',
        'enableAutoAuthReversalAfterVoid' => 'enableAutoAuthReversalAfterVoid',
        'enableExpresspayPanTranslation' => 'enableExpresspayPanTranslation',
        'enableCreditAuth' => 'enableCreditAuth',
        'industryCode' => 'industryCode',
        'sendAmexLevel2Data' => 'sendAmexLevel2Data',
        'softDescriptorType' => 'softDescriptorType',
        'vitalNumber' => 'vitalNumber',
        'bankNumber' => 'bankNumber',
        'chainNumber' => 'chainNumber',
        'merchantBinNumber' => 'merchantBinNumber',
        'merchantLocationNumber' => 'merchantLocationNumber',
        'storeID' => 'storeID',
        'travelAgencyCode' => 'travelAgencyCode',
        'travelAgencyName' => 'travelAgencyName',
        'settlementCurrency' => 'settlementCurrency',
        'enableLeastCostRouting' => 'enableLeastCostRouting',
        'enableCVVResponseIndicator' => 'enableCVVResponseIndicator',
        'enableMultiCurrencyProcessing' => 'enableMultiCurrencyProcessing',
        'enablePosNetworkSwitching' => 'enablePosNetworkSwitching',
        'enableDynamicCurrencyConversion' => 'enableDynamicCurrencyConversion',
        'merchantTier' => 'merchantTier'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'batchGroup' => 'setBatchGroup',
        'businessApplicationId' => 'setBusinessApplicationId',
        'merchantVerificationValue' => 'setMerchantVerificationValue',
        'abaNumber' => 'setAbaNumber',
        'acquirer' => 'setAcquirer',
        'merchantId' => 'setMerchantId',
        'terminalId' => 'setTerminalId',
        'paymentTypes' => 'setPaymentTypes',
        'currencies' => 'setCurrencies',
        'visaAggregatorId' => 'setVisaAggregatorId',
        'amexAggregatorId' => 'setAmexAggregatorId',
        'masterCardAggregatorId' => 'setMasterCardAggregatorId',
        'sicCode' => 'setSicCode',
        'allowMultipleBills' => 'setAllowMultipleBills',
        'allowMerchantDescriptorOverride' => 'setAllowMerchantDescriptorOverride',
        'enhancedData' => 'setEnhancedData',
        'fireSafetyIndicator' => 'setFireSafetyIndicator',
        'quasiCash' => 'setQuasiCash',
        'acquirerMerchantId' => 'setAcquirerMerchantId',
        'avsFormat' => 'setAvsFormat',
        'enableLongTransRefNo' => 'setEnableLongTransRefNo',
        'enableLevel2' => 'setEnableLevel2',
        'enableMultipleTransactionAdviceAddendum' => 'setEnableMultipleTransactionAdviceAddendum',
        'amexTransactionAdviceAddendum1' => 'setAmexTransactionAdviceAddendum1',
        'enableMultiLineItems' => 'setEnableMultiLineItems',
        'enableTransactionReferenceNumber' => 'setEnableTransactionReferenceNumber',
        'enableAutoAuthReversalAfterVoid' => 'setEnableAutoAuthReversalAfterVoid',
        'enableExpresspayPanTranslation' => 'setEnableExpresspayPanTranslation',
        'enableCreditAuth' => 'setEnableCreditAuth',
        'industryCode' => 'setIndustryCode',
        'sendAmexLevel2Data' => 'setSendAmexLevel2Data',
        'softDescriptorType' => 'setSoftDescriptorType',
        'vitalNumber' => 'setVitalNumber',
        'bankNumber' => 'setBankNumber',
        'chainNumber' => 'setChainNumber',
        'merchantBinNumber' => 'setMerchantBinNumber',
        'merchantLocationNumber' => 'setMerchantLocationNumber',
        'storeID' => 'setStoreID',
        'travelAgencyCode' => 'setTravelAgencyCode',
        'travelAgencyName' => 'setTravelAgencyName',
        'settlementCurrency' => 'setSettlementCurrency',
        'enableLeastCostRouting' => 'setEnableLeastCostRouting',
        'enableCVVResponseIndicator' => 'setEnableCVVResponseIndicator',
        'enableMultiCurrencyProcessing' => 'setEnableMultiCurrencyProcessing',
        'enablePosNetworkSwitching' => 'setEnablePosNetworkSwitching',
        'enableDynamicCurrencyConversion' => 'setEnableDynamicCurrencyConversion',
        'merchantTier' => 'setMerchantTier'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'batchGroup' => 'getBatchGroup',
        'businessApplicationId' => 'getBusinessApplicationId',
        'merchantVerificationValue' => 'getMerchantVerificationValue',
        'abaNumber' => 'getAbaNumber',
        'acquirer' => 'getAcquirer',
        'merchantId' => 'getMerchantId',
        'terminalId' => 'getTerminalId',
        'paymentTypes' => 'getPaymentTypes',
        'currencies' => 'getCurrencies',
        'visaAggregatorId' => 'getVisaAggregatorId',
        'amexAggregatorId' => 'getAmexAggregatorId',
        'masterCardAggregatorId' => 'getMasterCardAggregatorId',
        'sicCode' => 'getSicCode',
        'allowMultipleBills' => 'getAllowMultipleBills',
        'allowMerchantDescriptorOverride' => 'getAllowMerchantDescriptorOverride',
        'enhancedData' => 'getEnhancedData',
        'fireSafetyIndicator' => 'getFireSafetyIndicator',
        'quasiCash' => 'getQuasiCash',
        'acquirerMerchantId' => 'getAcquirerMerchantId',
        'avsFormat' => 'getAvsFormat',
        'enableLongTransRefNo' => 'getEnableLongTransRefNo',
        'enableLevel2' => 'getEnableLevel2',
        'enableMultipleTransactionAdviceAddendum' => 'getEnableMultipleTransactionAdviceAddendum',
        'amexTransactionAdviceAddendum1' => 'getAmexTransactionAdviceAddendum1',
        'enableMultiLineItems' => 'getEnableMultiLineItems',
        'enableTransactionReferenceNumber' => 'getEnableTransactionReferenceNumber',
        'enableAutoAuthReversalAfterVoid' => 'getEnableAutoAuthReversalAfterVoid',
        'enableExpresspayPanTranslation' => 'getEnableExpresspayPanTranslation',
        'enableCreditAuth' => 'getEnableCreditAuth',
        'industryCode' => 'getIndustryCode',
        'sendAmexLevel2Data' => 'getSendAmexLevel2Data',
        'softDescriptorType' => 'getSoftDescriptorType',
        'vitalNumber' => 'getVitalNumber',
        'bankNumber' => 'getBankNumber',
        'chainNumber' => 'getChainNumber',
        'merchantBinNumber' => 'getMerchantBinNumber',
        'merchantLocationNumber' => 'getMerchantLocationNumber',
        'storeID' => 'getStoreID',
        'travelAgencyCode' => 'getTravelAgencyCode',
        'travelAgencyName' => 'getTravelAgencyName',
        'settlementCurrency' => 'getSettlementCurrency',
        'enableLeastCostRouting' => 'getEnableLeastCostRouting',
        'enableCVVResponseIndicator' => 'getEnableCVVResponseIndicator',
        'enableMultiCurrencyProcessing' => 'getEnableMultiCurrencyProcessing',
        'enablePosNetworkSwitching' => 'getEnablePosNetworkSwitching',
        'enableDynamicCurrencyConversion' => 'getEnableDynamicCurrencyConversion',
        'merchantTier' => 'getMerchantTier'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['batchGroup'] = isset($data['batchGroup']) ? $data['batchGroup'] : null;
        $this->container['businessApplicationId'] = isset($data['businessApplicationId']) ? $data['businessApplicationId'] : null;
        $this->container['merchantVerificationValue'] = isset($data['merchantVerificationValue']) ? $data['merchantVerificationValue'] : null;
        $this->container['abaNumber'] = isset($data['abaNumber']) ? $data['abaNumber'] : null;
        $this->container['acquirer'] = isset($data['acquirer']) ? $data['acquirer'] : null;
        $this->container['merchantId'] = isset($data['merchantId']) ? $data['merchantId'] : null;
        $this->container['terminalId'] = isset($data['terminalId']) ? $data['terminalId'] : null;
        $this->container['paymentTypes'] = isset($data['paymentTypes']) ? $data['paymentTypes'] : null;
        $this->container['currencies'] = isset($data['currencies']) ? $data['currencies'] : null;
        $this->container['visaAggregatorId'] = isset($data['visaAggregatorId']) ? $data['visaAggregatorId'] : null;
        $this->container['amexAggregatorId'] = isset($data['amexAggregatorId']) ? $data['amexAggregatorId'] : null;
        $this->container['masterCardAggregatorId'] = isset($data['masterCardAggregatorId']) ? $data['masterCardAggregatorId'] : null;
        $this->container['sicCode'] = isset($data['sicCode']) ? $data['sicCode'] : null;
        $this->container['allowMultipleBills'] = isset($data['allowMultipleBills']) ? $data['allowMultipleBills'] : null;
        $this->container['allowMerchantDescriptorOverride'] = isset($data['allowMerchantDescriptorOverride']) ? $data['allowMerchantDescriptorOverride'] : null;
        $this->container['enhancedData'] = isset($data['enhancedData']) ? $data['enhancedData'] : null;
        $this->container['fireSafetyIndicator'] = isset($data['fireSafetyIndicator']) ? $data['fireSafetyIndicator'] : null;
        $this->container['quasiCash'] = isset($data['quasiCash']) ? $data['quasiCash'] : null;
        $this->container['acquirerMerchantId'] = isset($data['acquirerMerchantId']) ? $data['acquirerMerchantId'] : null;
        $this->container['avsFormat'] = isset($data['avsFormat']) ? $data['avsFormat'] : null;
        $this->container['enableLongTransRefNo'] = isset($data['enableLongTransRefNo']) ? $data['enableLongTransRefNo'] : null;
        $this->container['enableLevel2'] = isset($data['enableLevel2']) ? $data['enableLevel2'] : null;
        $this->container['enableMultipleTransactionAdviceAddendum'] = isset($data['enableMultipleTransactionAdviceAddendum']) ? $data['enableMultipleTransactionAdviceAddendum'] : null;
        $this->container['amexTransactionAdviceAddendum1'] = isset($data['amexTransactionAdviceAddendum1']) ? $data['amexTransactionAdviceAddendum1'] : null;
        $this->container['enableMultiLineItems'] = isset($data['enableMultiLineItems']) ? $data['enableMultiLineItems'] : null;
        $this->container['enableTransactionReferenceNumber'] = isset($data['enableTransactionReferenceNumber']) ? $data['enableTransactionReferenceNumber'] : null;
        $this->container['enableAutoAuthReversalAfterVoid'] = isset($data['enableAutoAuthReversalAfterVoid']) ? $data['enableAutoAuthReversalAfterVoid'] : null;
        $this->container['enableExpresspayPanTranslation'] = isset($data['enableExpresspayPanTranslation']) ? $data['enableExpresspayPanTranslation'] : null;
        $this->container['enableCreditAuth'] = isset($data['enableCreditAuth']) ? $data['enableCreditAuth'] : null;
        $this->container['industryCode'] = isset($data['industryCode']) ? $data['industryCode'] : null;
        $this->container['sendAmexLevel2Data'] = isset($data['sendAmexLevel2Data']) ? $data['sendAmexLevel2Data'] : null;
        $this->container['softDescriptorType'] = isset($data['softDescriptorType']) ? $data['softDescriptorType'] : null;
        $this->container['vitalNumber'] = isset($data['vitalNumber']) ? $data['vitalNumber'] : null;
        $this->container['bankNumber'] = isset($data['bankNumber']) ? $data['bankNumber'] : null;
        $this->container['chainNumber'] = isset($data['chainNumber']) ? $data['chainNumber'] : null;
        $this->container['merchantBinNumber'] = isset($data['merchantBinNumber']) ? $data['merchantBinNumber'] : null;
        $this->container['merchantLocationNumber'] = isset($data['merchantLocationNumber']) ? $data['merchantLocationNumber'] : null;
        $this->container['storeID'] = isset($data['storeID']) ? $data['storeID'] : null;
        $this->container['travelAgencyCode'] = isset($data['travelAgencyCode']) ? $data['travelAgencyCode'] : null;
        $this->container['travelAgencyName'] = isset($data['travelAgencyName']) ? $data['travelAgencyName'] : null;
        $this->container['settlementCurrency'] = isset($data['settlementCurrency']) ? $data['settlementCurrency'] : null;
        $this->container['enableLeastCostRouting'] = isset($data['enableLeastCostRouting']) ? $data['enableLeastCostRouting'] : null;
        $this->container['enableCVVResponseIndicator'] = isset($data['enableCVVResponseIndicator']) ? $data['enableCVVResponseIndicator'] : null;
        $this->container['enableMultiCurrencyProcessing'] = isset($data['enableMultiCurrencyProcessing']) ? $data['enableMultiCurrencyProcessing'] : null;
        $this->container['enablePosNetworkSwitching'] = isset($data['enablePosNetworkSwitching']) ? $data['enablePosNetworkSwitching'] : null;
        $this->container['enableDynamicCurrencyConversion'] = isset($data['enableDynamicCurrencyConversion']) ? $data['enableDynamicCurrencyConversion'] : null;
        $this->container['merchantTier'] = isset($data['merchantTier']) ? $data['merchantTier'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['merchantId'] === null) {
            $invalid_properties[] = "'merchantId' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['merchantId'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets batchGroup
     * @return string
     */
    public function getBatchGroup()
    {
        return $this->container['batchGroup'];
    }

    /**
     * Sets batchGroup
     * @param string $batchGroup Determines the batching group that separates merchants for special batching times. Batching groups can separate merchant batches by the following criteria:  * Timezone * Merchant deadlines * Large merchants (top 10) * Merchants with Service-Level Agreements  Applicable for Chase Paymentech Salem (chasepaymentechsalem), Streamline (streamline2), Six (six), Barclays (barclays2), Paymentech Tampa (paymentechtampa), CMCIC (cmcic), FDC Nashville (smartfdc), RUPAY, American Express Direct (amexdirect), GPN (gpn), VPC, GPX (gpx), CB2A, Barclays HISO (barclayshiso), TSYS (tsys) and FDI Global (fdiglobal) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setBatchGroup($batchGroup)
    {
        $this->container['batchGroup'] = $batchGroup;

        return $this;
    }

    /**
     * Gets businessApplicationId
     * @return string
     */
    public function getBusinessApplicationId()
    {
        return $this->container['businessApplicationId'];
    }

    /**
     * Sets businessApplicationId
     * @param string $businessApplicationId Indicates the type of money transfer used in the transaction. Applicable for VPC and GPX (gpx) processors.
     * @return $this
     */
    public function setBusinessApplicationId($businessApplicationId)
    {
        $this->container['businessApplicationId'] = $businessApplicationId;

        return $this;
    }

    /**
     * Gets merchantVerificationValue
     * @return string
     */
    public function getMerchantVerificationValue()
    {
        return $this->container['merchantVerificationValue'];
    }

    /**
     * Sets merchantVerificationValue
     * @param string $merchantVerificationValue Identify merchants that participate in Select Merchant Fee (SMF) programs. Unique to the merchant. Applicable for GPX (gpx) and VPC processors.
     * @return $this
     */
    public function setMerchantVerificationValue($merchantVerificationValue)
    {
        $this->container['merchantVerificationValue'] = $merchantVerificationValue;

        return $this;
    }

    /**
     * Gets abaNumber
     * @return string
     */
    public function getAbaNumber()
    {
        return $this->container['abaNumber'];
    }

    /**
     * Sets abaNumber
     * @param string $abaNumber Routing Number to identify banks within the United States. Applicable for GPX (gpx) processors.
     * @return $this
     */
    public function setAbaNumber($abaNumber)
    {
        $this->container['abaNumber'] = $abaNumber;

        return $this;
    }

    /**
     * Gets acquirer
     * @return \CyberSource\Model\CardProcessingConfigCommonAcquirer
     */
    public function getAcquirer()
    {
        return $this->container['acquirer'];
    }

    /**
     * Sets acquirer
     * @param \CyberSource\Model\CardProcessingConfigCommonAcquirer $acquirer
     * @return $this
     */
    public function setAcquirer($acquirer)
    {
        $this->container['acquirer'] = $acquirer;

        return $this;
    }

    /**
     * Gets merchantId
     * @return string
     */
    public function getMerchantId()
    {
        return $this->container['merchantId'];
    }

    /**
     * Sets merchantId
     * @param string $merchantId Merchant ID assigned by an acquirer or a processor. Should not be overriden by any other party.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>15</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays</td><td>cp, cnp, hybrid</td><td>Yes</td><td>1</td><td>11</td><td>^[0-9a-zA-Z]+$</td></tr> </table>
     * @return $this
     */
    public function setMerchantId($merchantId)
    {
        $this->container['merchantId'] = $merchantId;

        return $this;
    }

    /**
     * Gets terminalId
     * @return string
     */
    public function getTerminalId()
    {
        return $this->container['terminalId'];
    }

    /**
     * Sets terminalId
     * @param string $terminalId The 'Terminal Id' aka TID, is an identifier used for with your payments processor. Depending on the processor and payment acceptance type this may also be the default Terminal ID used for Card Present and Virtual Terminal transactions.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays HISO</td><td>cnp, hybrid</td><td>Yes</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> <tr><td>Barclays HISO</td><td>cp</td><td>No</td><td>1</td><td>16</td><td>^[0-9a-zA-Z]+$</td></tr> </table>
     * @return $this
     */
    public function setTerminalId($terminalId)
    {
        $this->container['terminalId'] = $terminalId;

        return $this;
    }

    /**
     * Gets paymentTypes
     * @return map[string,\CyberSource\Model\CardProcessingConfigCommonPaymentTypes]
     */
    public function getPaymentTypes()
    {
        return $this->container['paymentTypes'];
    }

    /**
     * Sets paymentTypes
     * @param map[string,\CyberSource\Model\CardProcessingConfigCommonPaymentTypes] $paymentTypes Valid values are: * VISA * MASTERCARD * AMERICAN_EXPRESS * CUP * EFTPOS * DINERS_CLUB * DISCOVER * JCB
     * @return $this
     */
    public function setPaymentTypes($paymentTypes)
    {
        $this->container['paymentTypes'] = $paymentTypes;

        return $this;
    }

    /**
     * Gets currencies
     * @return map[string,\CyberSource\Model\CardProcessingConfigCommonCurrencies1]
     */
    public function getCurrencies()
    {
        return $this->container['currencies'];
    }

    /**
     * Sets currencies
     * @param map[string,\CyberSource\Model\CardProcessingConfigCommonCurrencies1] $currencies Three-character [ISO 4217 ALPHA-3 Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)
     * @return $this
     */
    public function setCurrencies($currencies)
    {
        $this->container['currencies'] = $currencies;

        return $this;
    }

    /**
     * Gets visaAggregatorId
     * @return string
     */
    public function getVisaAggregatorId()
    {
        return $this->container['visaAggregatorId'];
    }

    /**
     * Sets visaAggregatorId
     * @param string $visaAggregatorId This field is used as aggregator Id when Visa payment type is selected
     * @return $this
     */
    public function setVisaAggregatorId($visaAggregatorId)
    {
        $this->container['visaAggregatorId'] = $visaAggregatorId;

        return $this;
    }

    /**
     * Gets amexAggregatorId
     * @return string
     */
    public function getAmexAggregatorId()
    {
        return $this->container['amexAggregatorId'];
    }

    /**
     * Sets amexAggregatorId
     * @param string $amexAggregatorId This field is used as aggregator Id when Amex payment type is selected
     * @return $this
     */
    public function setAmexAggregatorId($amexAggregatorId)
    {
        $this->container['amexAggregatorId'] = $amexAggregatorId;

        return $this;
    }

    /**
     * Gets masterCardAggregatorId
     * @return string
     */
    public function getMasterCardAggregatorId()
    {
        return $this->container['masterCardAggregatorId'];
    }

    /**
     * Sets masterCardAggregatorId
     * @param string $masterCardAggregatorId This field is used as aggregator Id when Master Card payment type is selected
     * @return $this
     */
    public function setMasterCardAggregatorId($masterCardAggregatorId)
    {
        $this->container['masterCardAggregatorId'] = $masterCardAggregatorId;

        return $this;
    }

    /**
     * Gets sicCode
     * @return string
     */
    public function getSicCode()
    {
        return $this->container['sicCode'];
    }

    /**
     * Sets sicCode
     * @param string $sicCode The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.
     * @return $this
     */
    public function setSicCode($sicCode)
    {
        $this->container['sicCode'] = $sicCode;

        return $this;
    }

    /**
     * Gets allowMultipleBills
     * @return bool
     */
    public function getAllowMultipleBills()
    {
        return $this->container['allowMultipleBills'];
    }

    /**
     * Sets allowMultipleBills
     * @param bool $allowMultipleBills Allows multiple captures for a single authorization transaction. Applicable for Paymentech Tampa (paymentechtampa), VPC, American Express Direct (amexdirect) and GPX (gpx) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, hybrid</td><td>Yes</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cnp</td><td>No</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setAllowMultipleBills($allowMultipleBills)
    {
        $this->container['allowMultipleBills'] = $allowMultipleBills;

        return $this;
    }

    /**
     * Gets allowMerchantDescriptorOverride
     * @return bool
     */
    public function getAllowMerchantDescriptorOverride()
    {
        return $this->container['allowMerchantDescriptorOverride'];
    }

    /**
     * Sets allowMerchantDescriptorOverride
     * @param bool $allowMerchantDescriptorOverride Enables partner to enable/disable merchant descriptors values. Applicable for VPC, EFTPOS and CUP processors.
     * @return $this
     */
    public function setAllowMerchantDescriptorOverride($allowMerchantDescriptorOverride)
    {
        $this->container['allowMerchantDescriptorOverride'] = $allowMerchantDescriptorOverride;

        return $this;
    }

    /**
     * Gets enhancedData
     * @return string
     */
    public function getEnhancedData()
    {
        return $this->container['enhancedData'];
    }

    /**
     * Sets enhancedData
     * @param string $enhancedData To enable airline transactions. Applicable for TSYS (tsys), VPC, Elavon Americas (elavonamericas), FDI Global (fdiglobal), GPX (gpx), Barclays (barclays2) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td></tr> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setEnhancedData($enhancedData)
    {
        $this->container['enhancedData'] = $enhancedData;

        return $this;
    }

    /**
     * Gets fireSafetyIndicator
     * @return bool
     */
    public function getFireSafetyIndicator()
    {
        return $this->container['fireSafetyIndicator'];
    }

    /**
     * Sets fireSafetyIndicator
     * @param bool $fireSafetyIndicator Indicates whether the merchant is compliant with Hotel and Motel Fire Safety Act of 1990. Applicable for GPX (gpx) and VPC processors.
     * @return $this
     */
    public function setFireSafetyIndicator($fireSafetyIndicator)
    {
        $this->container['fireSafetyIndicator'] = $fireSafetyIndicator;

        return $this;
    }

    /**
     * Gets quasiCash
     * @return bool
     */
    public function getQuasiCash()
    {
        return $this->container['quasiCash'];
    }

    /**
     * Sets quasiCash
     * @param bool $quasiCash To enable quasi-cash transactions. A quasi-cash transaction is a cash-like transaction for the sale of items that are directly convertible to cash, such as:- Casino gaming chips, Money orders, Wire transfers.  Applicable for GPX (gpx), TSYS (tsys), Barclays (barclays2) and VPC processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setQuasiCash($quasiCash)
    {
        $this->container['quasiCash'] = $quasiCash;

        return $this;
    }

    /**
     * Gets acquirerMerchantId
     * @return string
     */
    public function getAcquirerMerchantId()
    {
        return $this->container['acquirerMerchantId'];
    }

    /**
     * Sets acquirerMerchantId
     * @param string $acquirerMerchantId Identifier assigned by the acquirer. Applicable for RUPAY, VPC and Six (six) processors.
     * @return $this
     */
    public function setAcquirerMerchantId($acquirerMerchantId)
    {
        $this->container['acquirerMerchantId'] = $acquirerMerchantId;

        return $this;
    }

    /**
     * Gets avsFormat
     * @return string
     */
    public function getAvsFormat()
    {
        return $this->container['avsFormat'];
    }

    /**
     * Sets avsFormat
     * @param string $avsFormat Enables Enhanced AVS/Automated Address Verification Plus (AAV+).  Valid values: \"basic\" - Standard address verification system.   When a processor supports AVS for a transaction's card type, the issuing bank uses AVS to confirm that the customer has provided the correct billing address.   When a customer provides incorrect information, the transaction might be fraudulent. \"basic + name\" - Enhanced address verification system.   Consists of the standard AVS functionality plus verification of some additional fields.   The additional fields that are verified for Enhanced AVS are:   - customer_firstname   - customer_lastname \"basic + name + shipto\" - Automated address verification plus.   Consists of the Enhanced AVS functionality plus verification of some additional fields.   AAV+ intended for merchants who deliver physical goods to a different address than the billing address.   AAV+ verifies the additional fields only when the standard and Enhanced AVS tests pass first.   For information about Enhanced AVS - The additional fields that are verified for AAV+ are:   - ship_to_firstname   - ship_to_lastname   - ship_to_address1   - ship_to_country   - ship_to_zip   - ship_to_phone   - customer_phone(American Express Direct only)  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>basic</td></tr> </table>
     * @return $this
     */
    public function setAvsFormat($avsFormat)
    {
        $this->container['avsFormat'] = $avsFormat;

        return $this;
    }

    /**
     * Gets enableLongTransRefNo
     * @return bool
     */
    public function getEnableLongTransRefNo()
    {
        return $this->container['enableLongTransRefNo'];
    }

    /**
     * Sets enableLongTransRefNo
     * @param bool $enableLongTransRefNo Amex Direct specific merchant config value which determines what length (either 9 or Unique 12-char reference number) of reference number will be CYBS generated if the merchant does not pass in a trans_ref_no. Can be any combination of alpha, numeric and special characters, and/or binary data in hexadecimal.  Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setEnableLongTransRefNo($enableLongTransRefNo)
    {
        $this->container['enableLongTransRefNo'] = $enableLongTransRefNo;

        return $this;
    }

    /**
     * Gets enableLevel2
     * @return bool
     */
    public function getEnableLevel2()
    {
        return $this->container['enableLevel2'];
    }

    /**
     * Sets enableLevel2
     * @param bool $enableLevel2 Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setEnableLevel2($enableLevel2)
    {
        $this->container['enableLevel2'] = $enableLevel2;

        return $this;
    }

    /**
     * Gets enableMultipleTransactionAdviceAddendum
     * @return bool
     */
    public function getEnableMultipleTransactionAdviceAddendum()
    {
        return $this->container['enableMultipleTransactionAdviceAddendum'];
    }

    /**
     * Sets enableMultipleTransactionAdviceAddendum
     * @param bool $enableMultipleTransactionAdviceAddendum This flag related to multiple transaction advice addendum field. It is used to display descriptive information about a transaction on customer's American Express card statement. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setEnableMultipleTransactionAdviceAddendum($enableMultipleTransactionAdviceAddendum)
    {
        $this->container['enableMultipleTransactionAdviceAddendum'] = $enableMultipleTransactionAdviceAddendum;

        return $this;
    }

    /**
     * Gets amexTransactionAdviceAddendum1
     * @return string
     */
    public function getAmexTransactionAdviceAddendum1()
    {
        return $this->container['amexTransactionAdviceAddendum1'];
    }

    /**
     * Sets amexTransactionAdviceAddendum1
     * @param string $amexTransactionAdviceAddendum1 Advice addendum field. It is used to display descriptive information about a transaction on customer's American Express card statement. Applicable for TSYS (tsys), FDI Global (fdiglobal) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>40</td><td>^[0-9a-zA-Z&#92;-\\s.]+$</td></tr> </table>
     * @return $this
     */
    public function setAmexTransactionAdviceAddendum1($amexTransactionAdviceAddendum1)
    {
        $this->container['amexTransactionAdviceAddendum1'] = $amexTransactionAdviceAddendum1;

        return $this;
    }

    /**
     * Gets enableMultiLineItems
     * @return bool
     */
    public function getEnableMultiLineItems()
    {
        return $this->container['enableMultiLineItems'];
    }

    /**
     * Sets enableMultiLineItems
     * @param bool $enableMultiLineItems This flag is related to offer/line item details to be included instead of sending one line item, and a grand total. Example, offer0, offer 1...offer n. Applicable for American Express Direct (amexdirect) and Elavon Americas (elavonamericas) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setEnableMultiLineItems($enableMultiLineItems)
    {
        $this->container['enableMultiLineItems'] = $enableMultiLineItems;

        return $this;
    }

    /**
     * Gets enableTransactionReferenceNumber
     * @return bool
     */
    public function getEnableTransactionReferenceNumber()
    {
        return $this->container['enableTransactionReferenceNumber'];
    }

    /**
     * Sets enableTransactionReferenceNumber
     * @param bool $enableTransactionReferenceNumber To enable merchant to send in transaction reference number (unique reconciliation ID). Applicable for VPC, Vero (vero), FDI Global (fdiglobal), Six (six), CB2A, CUP, VPC, Chase Paymentech Salem (chasepaymentechsalem), Fiserv (fiserv), Elavon Americas (elavonamericas) and EFTPOS processors.
     * @return $this
     */
    public function setEnableTransactionReferenceNumber($enableTransactionReferenceNumber)
    {
        $this->container['enableTransactionReferenceNumber'] = $enableTransactionReferenceNumber;

        return $this;
    }

    /**
     * Gets enableAutoAuthReversalAfterVoid
     * @return bool
     */
    public function getEnableAutoAuthReversalAfterVoid()
    {
        return $this->container['enableAutoAuthReversalAfterVoid'];
    }

    /**
     * Sets enableAutoAuthReversalAfterVoid
     * @param bool $enableAutoAuthReversalAfterVoid Enables to meet the Visa mandate requirements to reverse unused authorizations, benefitting the customer by releasing the hold on unused credit card funds. Applicable for CB2A, Elavon Americas (elavonamericas), Six (six), VPC and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cp, cnp, hybrid</td><td>No</td><td>No</td></tr> </table>
     * @return $this
     */
    public function setEnableAutoAuthReversalAfterVoid($enableAutoAuthReversalAfterVoid)
    {
        $this->container['enableAutoAuthReversalAfterVoid'] = $enableAutoAuthReversalAfterVoid;

        return $this;
    }

    /**
     * Gets enableExpresspayPanTranslation
     * @return bool
     */
    public function getEnableExpresspayPanTranslation()
    {
        return $this->container['enableExpresspayPanTranslation'];
    }

    /**
     * Sets enableExpresspayPanTranslation
     * @param bool $enableExpresspayPanTranslation When this is enabled, authorization responses from American Express expresspay transactions include the Primary Account Number (PAN) and expiration date of the card. Applicable for American Express Direct (amexdirect) processor.
     * @return $this
     */
    public function setEnableExpresspayPanTranslation($enableExpresspayPanTranslation)
    {
        $this->container['enableExpresspayPanTranslation'] = $enableExpresspayPanTranslation;

        return $this;
    }

    /**
     * Gets enableCreditAuth
     * @return bool
     */
    public function getEnableCreditAuth()
    {
        return $this->container['enableCreditAuth'];
    }

    /**
     * Sets enableCreditAuth
     * @param bool $enableCreditAuth Authorizes a credit. Reduces refund chargebacks and prevents customers from seeing the online update for credits which are otherwise offline settlements.
     * @return $this
     */
    public function setEnableCreditAuth($enableCreditAuth)
    {
        $this->container['enableCreditAuth'] = $enableCreditAuth;

        return $this;
    }

    /**
     * Gets industryCode
     * @return string
     */
    public function getIndustryCode()
    {
        return $this->container['industryCode'];
    }

    /**
     * Sets industryCode
     * @param string $industryCode Field used to identify the industry type of the merchant submitting the authorization request.  Valid values: `0` – unknown or unsure `A` – auto rental (EMV supported) `B` – bank/financial institution (EMV supported) `D` – direct marketing `F` – food/restaurant (EMV supported) `G` – grocery store/super market (EMV supported) `H` – hotel (EMV supported) `L` – limited amount terminal (EMV supported) `O` – oil company/automated fueling system (EMV supported) `P` – passenger transport (EMV supported) `R` – retail (EMV supported) Applicable for TSYS (tsys), RUPAY and Elavon Americas (elavonamericas) processors.   Possible values: - 0 - A - B - D - F - G - H - L - O - P - R
     * @return $this
     */
    public function setIndustryCode($industryCode)
    {
        $this->container['industryCode'] = $industryCode;

        return $this;
    }

    /**
     * Gets sendAmexLevel2Data
     * @return bool
     */
    public function getSendAmexLevel2Data()
    {
        return $this->container['sendAmexLevel2Data'];
    }

    /**
     * Sets sendAmexLevel2Data
     * @param bool $sendAmexLevel2Data Field that indicates whether merchant will send level 2 data for Amex cards. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setSendAmexLevel2Data($sendAmexLevel2Data)
    {
        $this->container['sendAmexLevel2Data'] = $sendAmexLevel2Data;

        return $this;
    }

    /**
     * Gets softDescriptorType
     * @return string
     */
    public function getSoftDescriptorType()
    {
        return $this->container['softDescriptorType'];
    }

    /**
     * Sets softDescriptorType
     * @param string $softDescriptorType A soft descriptor is a text, rendered on a cardholder's statement, describing a particular product or service, purchased by the cardholder. Descriptors are intended to help the cardholder identify the products or services purchased. Valid values: `1` - trans_ref_no `2` - merchant_descriptor `3` - trans_ref_no and merchant_descriptor Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setSoftDescriptorType($softDescriptorType)
    {
        $this->container['softDescriptorType'] = $softDescriptorType;

        return $this;
    }

    /**
     * Gets vitalNumber
     * @return string
     */
    public function getVitalNumber()
    {
        return $this->container['vitalNumber'];
    }

    /**
     * Sets vitalNumber
     * @param string $vitalNumber V-number provided by TSYS info. The leading `V` must be replaced by a `7`. For example, replace `V1234567` with `71234567`. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setVitalNumber($vitalNumber)
    {
        $this->container['vitalNumber'] = $vitalNumber;

        return $this;
    }

    /**
     * Gets bankNumber
     * @return string
     */
    public function getBankNumber()
    {
        return $this->container['bankNumber'];
    }

    /**
     * Sets bankNumber
     * @param string $bankNumber 6 digit agent bank number provided by acquirer. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setBankNumber($bankNumber)
    {
        $this->container['bankNumber'] = $bankNumber;

        return $this;
    }

    /**
     * Gets chainNumber
     * @return string
     */
    public function getChainNumber()
    {
        return $this->container['chainNumber'];
    }

    /**
     * Sets chainNumber
     * @param string $chainNumber 6 digit chain number provided by acquirer. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setChainNumber($chainNumber)
    {
        $this->container['chainNumber'] = $chainNumber;

        return $this;
    }

    /**
     * Gets merchantBinNumber
     * @return string
     */
    public function getMerchantBinNumber()
    {
        return $this->container['merchantBinNumber'];
    }

    /**
     * Sets merchantBinNumber
     * @param string $merchantBinNumber 6 digits acquirer bank identification number. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setMerchantBinNumber($merchantBinNumber)
    {
        $this->container['merchantBinNumber'] = $merchantBinNumber;

        return $this;
    }

    /**
     * Gets merchantLocationNumber
     * @return string
     */
    public function getMerchantLocationNumber()
    {
        return $this->container['merchantLocationNumber'];
    }

    /**
     * Sets merchantLocationNumber
     * @param string $merchantLocationNumber 5 digit merchant location number. Unless otherwise specified by merchant's bank or processor, this field should default to 00001. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setMerchantLocationNumber($merchantLocationNumber)
    {
        $this->container['merchantLocationNumber'] = $merchantLocationNumber;

        return $this;
    }

    /**
     * Gets storeID
     * @return string
     */
    public function getStoreID()
    {
        return $this->container['storeID'];
    }

    /**
     * Sets storeID
     * @param string $storeID 4 digits number used to identify a specific merchant store location within the member systems. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setStoreID($storeID)
    {
        $this->container['storeID'] = $storeID;

        return $this;
    }

    /**
     * Gets travelAgencyCode
     * @return string
     */
    public function getTravelAgencyCode()
    {
        return $this->container['travelAgencyCode'];
    }

    /**
     * Sets travelAgencyCode
     * @param string $travelAgencyCode Contains travel agency code if airline ticket was issued by a travel agency. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setTravelAgencyCode($travelAgencyCode)
    {
        $this->container['travelAgencyCode'] = $travelAgencyCode;

        return $this;
    }

    /**
     * Gets travelAgencyName
     * @return string
     */
    public function getTravelAgencyName()
    {
        return $this->container['travelAgencyName'];
    }

    /**
     * Sets travelAgencyName
     * @param string $travelAgencyName Contains travel agency name if airline ticket was issued by travel agency. Applicable for TSYS (tsys) processor.
     * @return $this
     */
    public function setTravelAgencyName($travelAgencyName)
    {
        $this->container['travelAgencyName'] = $travelAgencyName;

        return $this;
    }

    /**
     * Gets settlementCurrency
     * @return string
     */
    public function getSettlementCurrency()
    {
        return $this->container['settlementCurrency'];
    }

    /**
     * Sets settlementCurrency
     * @param string $settlementCurrency This field is used to indicate Merchant's settlement currency. [ISO 4217 ALPHA-3 Standard Currency Codes] Applicable for TSYS (tsys) and Streamline (streamline2) processors.
     * @return $this
     */
    public function setSettlementCurrency($settlementCurrency)
    {
        $this->container['settlementCurrency'] = $settlementCurrency;

        return $this;
    }

    /**
     * Gets enableLeastCostRouting
     * @return bool
     */
    public function getEnableLeastCostRouting()
    {
        return $this->container['enableLeastCostRouting'];
    }

    /**
     * Sets enableLeastCostRouting
     * @param bool $enableLeastCostRouting Indicates whether Least Cost Routing is enabled. Applicable for EFTPOS and CUP processors.
     * @return $this
     */
    public function setEnableLeastCostRouting($enableLeastCostRouting)
    {
        $this->container['enableLeastCostRouting'] = $enableLeastCostRouting;

        return $this;
    }

    /**
     * Gets enableCVVResponseIndicator
     * @return bool
     */
    public function getEnableCVVResponseIndicator()
    {
        return $this->container['enableCVVResponseIndicator'];
    }

    /**
     * Sets enableCVVResponseIndicator
     * @param bool $enableCVVResponseIndicator This field denotes EFTPOS Merchant's choice of receiving CVV Processing Response in return. Applicable for EFTPOS processors.
     * @return $this
     */
    public function setEnableCVVResponseIndicator($enableCVVResponseIndicator)
    {
        $this->container['enableCVVResponseIndicator'] = $enableCVVResponseIndicator;

        return $this;
    }

    /**
     * Gets enableMultiCurrencyProcessing
     * @return string
     */
    public function getEnableMultiCurrencyProcessing()
    {
        return $this->container['enableMultiCurrencyProcessing'];
    }

    /**
     * Sets enableMultiCurrencyProcessing
     * @param string $enableMultiCurrencyProcessing Applicable for Barclays (barclays2) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>Yes</td></tr> </table>
     * @return $this
     */
    public function setEnableMultiCurrencyProcessing($enableMultiCurrencyProcessing)
    {
        $this->container['enableMultiCurrencyProcessing'] = $enableMultiCurrencyProcessing;

        return $this;
    }

    /**
     * Gets enablePosNetworkSwitching
     * @return bool
     */
    public function getEnablePosNetworkSwitching()
    {
        return $this->container['enablePosNetworkSwitching'];
    }

    /**
     * Sets enablePosNetworkSwitching
     * @param bool $enablePosNetworkSwitching 'POS Network Switching' or 'Alternate Routing' means merchant can process PIN Debit transactions without a PIN. Set the value to 'Yes' if it is supported. Applicable for FDI Global (fdiglobal) processor.
     * @return $this
     */
    public function setEnablePosNetworkSwitching($enablePosNetworkSwitching)
    {
        $this->container['enablePosNetworkSwitching'] = $enablePosNetworkSwitching;

        return $this;
    }

    /**
     * Gets enableDynamicCurrencyConversion
     * @return bool
     */
    public function getEnableDynamicCurrencyConversion()
    {
        return $this->container['enableDynamicCurrencyConversion'];
    }

    /**
     * Sets enableDynamicCurrencyConversion
     * @param bool $enableDynamicCurrencyConversion Enable dynamic currency conversion for a merchant.
     * @return $this
     */
    public function setEnableDynamicCurrencyConversion($enableDynamicCurrencyConversion)
    {
        $this->container['enableDynamicCurrencyConversion'] = $enableDynamicCurrencyConversion;

        return $this;
    }

    /**
     * Gets merchantTier
     * @return string
     */
    public function getMerchantTier()
    {
        return $this->container['merchantTier'];
    }

    /**
     * Sets merchantTier
     * @param string $merchantTier Merchant Tier defines the type of merchant, the numeric Merchant Tier value is allocated by EFTPOS. Applicable for EFTPOS processors.
     * @return $this
     */
    public function setMerchantTier($merchantTier)
    {
        $this->container['merchantTier'] = $merchantTier;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


