<?php
/**
 * Ptsv2payoutsProcessingInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Ptsv2payoutsProcessingInformation Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Ptsv2payoutsProcessingInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ptsv2payouts_processingInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'businessApplicationId' => 'string',
        'networkRoutingOrder' => 'string',
        'commerceIndicator' => 'string',
        'reconciliationId' => 'string',
        'payoutsOptions' => '\CyberSource\Model\Ptsv2payoutsProcessingInformationPayoutsOptions',
        'transactionReason' => 'string',
        'purposeOfPayment' => 'string',
        'fundingOptions' => '\CyberSource\Model\Ptsv2payoutsProcessingInformationFundingOptions',
        'languageCode' => 'string',
        'purchaseOptions' => '\CyberSource\Model\Ptsv2payoutsProcessingInformationPurchaseOptions'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'businessApplicationId' => null,
        'networkRoutingOrder' => null,
        'commerceIndicator' => null,
        'reconciliationId' => null,
        'payoutsOptions' => null,
        'transactionReason' => null,
        'purposeOfPayment' => null,
        'fundingOptions' => null,
        'languageCode' => null,
        'purchaseOptions' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'businessApplicationId' => 'businessApplicationId',
        'networkRoutingOrder' => 'networkRoutingOrder',
        'commerceIndicator' => 'commerceIndicator',
        'reconciliationId' => 'reconciliationId',
        'payoutsOptions' => 'payoutsOptions',
        'transactionReason' => 'transactionReason',
        'purposeOfPayment' => 'purposeOfPayment',
        'fundingOptions' => 'fundingOptions',
        'languageCode' => 'languageCode',
        'purchaseOptions' => 'purchaseOptions'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'businessApplicationId' => 'setBusinessApplicationId',
        'networkRoutingOrder' => 'setNetworkRoutingOrder',
        'commerceIndicator' => 'setCommerceIndicator',
        'reconciliationId' => 'setReconciliationId',
        'payoutsOptions' => 'setPayoutsOptions',
        'transactionReason' => 'setTransactionReason',
        'purposeOfPayment' => 'setPurposeOfPayment',
        'fundingOptions' => 'setFundingOptions',
        'languageCode' => 'setLanguageCode',
        'purchaseOptions' => 'setPurchaseOptions'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'businessApplicationId' => 'getBusinessApplicationId',
        'networkRoutingOrder' => 'getNetworkRoutingOrder',
        'commerceIndicator' => 'getCommerceIndicator',
        'reconciliationId' => 'getReconciliationId',
        'payoutsOptions' => 'getPayoutsOptions',
        'transactionReason' => 'getTransactionReason',
        'purposeOfPayment' => 'getPurposeOfPayment',
        'fundingOptions' => 'getFundingOptions',
        'languageCode' => 'getLanguageCode',
        'purchaseOptions' => 'getPurchaseOptions'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['businessApplicationId'] = isset($data['businessApplicationId']) ? $data['businessApplicationId'] : null;
        $this->container['networkRoutingOrder'] = isset($data['networkRoutingOrder']) ? $data['networkRoutingOrder'] : null;
        $this->container['commerceIndicator'] = isset($data['commerceIndicator']) ? $data['commerceIndicator'] : null;
        $this->container['reconciliationId'] = isset($data['reconciliationId']) ? $data['reconciliationId'] : null;
        $this->container['payoutsOptions'] = isset($data['payoutsOptions']) ? $data['payoutsOptions'] : null;
        $this->container['transactionReason'] = isset($data['transactionReason']) ? $data['transactionReason'] : null;
        $this->container['purposeOfPayment'] = isset($data['purposeOfPayment']) ? $data['purposeOfPayment'] : null;
        $this->container['fundingOptions'] = isset($data['fundingOptions']) ? $data['fundingOptions'] : null;
        $this->container['languageCode'] = isset($data['languageCode']) ? $data['languageCode'] : null;
        $this->container['purchaseOptions'] = isset($data['purchaseOptions']) ? $data['purchaseOptions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets businessApplicationId
     * @return string
     */
    public function getBusinessApplicationId()
    {
        return $this->container['businessApplicationId'];
    }

    /**
     * Sets businessApplicationId
     * @param string $businessApplicationId Payouts transaction type.  Applicable Processors: FDC Compass, Paymentech, CtV  Possible values:  **Credit Card Bill Payment**   - **CP**: credit card bill payment  **Funds Disbursement**   - **FD**: funds disbursement  - **GD**: government disbursement  - **MD**: merchant disbursement  **Money Transfer**   - **AA**: account to account. Sender and receiver are same person.  - **PP**: person to person. Sender and receiver are different.  **Prepaid Load**   - **TU**: top up
     * @return $this
     */
    public function setBusinessApplicationId($businessApplicationId)
    {
        $this->container['businessApplicationId'] = $businessApplicationId;

        return $this;
    }

    /**
     * Gets networkRoutingOrder
     * @return string
     */
    public function getNetworkRoutingOrder()
    {
        return $this->container['networkRoutingOrder'];
    }

    /**
     * Sets networkRoutingOrder
     * @param string $networkRoutingOrder This field is optionally used by Push Payments Gateway participants (merchants and acquirers) to get the attributes for specified networks only. The networks specified in this field must be a subset of the information provided during program enrollment. Refer to Sharing Group Code/Network Routing Order. Note: Supported only in US for domestic transactions involving Push Payments Gateway Service.  VisaNet checks to determine if there are issuer routing preferences for any of the networks specified by the network routing order. If an issuer preference exists for one of the specified debit networks, VisaNet makes a routing selection based on the issuer's preference.  If an issuer preference exists for more than one of the specified debit networks, or if no issuer preference exists, VisaNet makes a selection based on the acquirer's routing priorities.
     * @return $this
     */
    public function setNetworkRoutingOrder($networkRoutingOrder)
    {
        $this->container['networkRoutingOrder'] = $networkRoutingOrder;

        return $this;
    }

    /**
     * Gets commerceIndicator
     * @return string
     */
    public function getCommerceIndicator()
    {
        return $this->container['commerceIndicator'];
    }

    /**
     * Sets commerceIndicator
     * @param string $commerceIndicator Type of transaction.  Value for an OCT transaction: - `internet`
     * @return $this
     */
    public function setCommerceIndicator($commerceIndicator)
    {
        $this->container['commerceIndicator'] = $commerceIndicator;

        return $this;
    }

    /**
     * Gets reconciliationId
     * @return string
     */
    public function getReconciliationId()
    {
        return $this->container['reconciliationId'];
    }

    /**
     * Sets reconciliationId
     * @param string $reconciliationId Please check with Cybersource customer support to see if your merchant account is configured correctly so you can include this field in your request. * For Payouts: max length for FDCCompass is String (22).
     * @return $this
     */
    public function setReconciliationId($reconciliationId)
    {
        $this->container['reconciliationId'] = $reconciliationId;

        return $this;
    }

    /**
     * Gets payoutsOptions
     * @return \CyberSource\Model\Ptsv2payoutsProcessingInformationPayoutsOptions
     */
    public function getPayoutsOptions()
    {
        return $this->container['payoutsOptions'];
    }

    /**
     * Sets payoutsOptions
     * @param \CyberSource\Model\Ptsv2payoutsProcessingInformationPayoutsOptions $payoutsOptions
     * @return $this
     */
    public function setPayoutsOptions($payoutsOptions)
    {
        $this->container['payoutsOptions'] = $payoutsOptions;

        return $this;
    }

    /**
     * Gets transactionReason
     * @return string
     */
    public function getTransactionReason()
    {
        return $this->container['transactionReason'];
    }

    /**
     * Sets transactionReason
     * @param string $transactionReason Transaction reason code.
     * @return $this
     */
    public function setTransactionReason($transactionReason)
    {
        $this->container['transactionReason'] = $transactionReason;

        return $this;
    }

    /**
     * Gets purposeOfPayment
     * @return string
     */
    public function getPurposeOfPayment()
    {
        return $this->container['purposeOfPayment'];
    }

    /**
     * Sets purposeOfPayment
     * @param string $purposeOfPayment This field is applicable for AFT and OCT transactions. For list of supported values, please refer to Developer Guide.
     * @return $this
     */
    public function setPurposeOfPayment($purposeOfPayment)
    {
        $this->container['purposeOfPayment'] = $purposeOfPayment;

        return $this;
    }

    /**
     * Gets fundingOptions
     * @return \CyberSource\Model\Ptsv2payoutsProcessingInformationFundingOptions
     */
    public function getFundingOptions()
    {
        return $this->container['fundingOptions'];
    }

    /**
     * Sets fundingOptions
     * @param \CyberSource\Model\Ptsv2payoutsProcessingInformationFundingOptions $fundingOptions
     * @return $this
     */
    public function setFundingOptions($fundingOptions)
    {
        $this->container['fundingOptions'] = $fundingOptions;

        return $this;
    }

    /**
     * Gets languageCode
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->container['languageCode'];
    }

    /**
     * Sets languageCode
     * @param string $languageCode Contains the ISO 639-2 defined language Code
     * @return $this
     */
    public function setLanguageCode($languageCode)
    {
        $this->container['languageCode'] = $languageCode;

        return $this;
    }

    /**
     * Gets purchaseOptions
     * @return \CyberSource\Model\Ptsv2payoutsProcessingInformationPurchaseOptions
     */
    public function getPurchaseOptions()
    {
        return $this->container['purchaseOptions'];
    }

    /**
     * Sets purchaseOptions
     * @param \CyberSource\Model\Ptsv2payoutsProcessingInformationPurchaseOptions $purchaseOptions
     * @return $this
     */
    public function setPurchaseOptions($purchaseOptions)
    {
        $this->container['purchaseOptions'] = $purchaseOptions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


