<?php
/**
 * SAConfigPaymentTypesCardTypesDiscover
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * SAConfigPaymentTypesCardTypesDiscover Class Doc Comment
 *
 * @category    Class
 * @description Object containing supported Card Types and settings
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SAConfigPaymentTypesCardTypesDiscover implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SAConfig_paymentTypes_cardTypes_discover';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'cardVerificationNumberSupported' => 'bool',
        'cardVerificationNumberDisplay' => 'bool',
        'payerAuthenticationSupported' => 'bool',
        'supportedCurrencies' => 'string[]',
        'method' => 'string',
        'cardVerificationNumberRequired' => 'bool',
        'payerAuthenticationEnabled' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'cardVerificationNumberSupported' => null,
        'cardVerificationNumberDisplay' => null,
        'payerAuthenticationSupported' => null,
        'supportedCurrencies' => null,
        'method' => null,
        'cardVerificationNumberRequired' => null,
        'payerAuthenticationEnabled' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'cardVerificationNumberSupported' => 'cardVerificationNumberSupported',
        'cardVerificationNumberDisplay' => 'cardVerificationNumberDisplay',
        'payerAuthenticationSupported' => 'payerAuthenticationSupported',
        'supportedCurrencies' => 'supportedCurrencies',
        'method' => 'method',
        'cardVerificationNumberRequired' => 'cardVerificationNumberRequired',
        'payerAuthenticationEnabled' => 'payerAuthenticationEnabled'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'cardVerificationNumberSupported' => 'setCardVerificationNumberSupported',
        'cardVerificationNumberDisplay' => 'setCardVerificationNumberDisplay',
        'payerAuthenticationSupported' => 'setPayerAuthenticationSupported',
        'supportedCurrencies' => 'setSupportedCurrencies',
        'method' => 'setMethod',
        'cardVerificationNumberRequired' => 'setCardVerificationNumberRequired',
        'payerAuthenticationEnabled' => 'setPayerAuthenticationEnabled'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'cardVerificationNumberSupported' => 'getCardVerificationNumberSupported',
        'cardVerificationNumberDisplay' => 'getCardVerificationNumberDisplay',
        'payerAuthenticationSupported' => 'getPayerAuthenticationSupported',
        'supportedCurrencies' => 'getSupportedCurrencies',
        'method' => 'getMethod',
        'cardVerificationNumberRequired' => 'getCardVerificationNumberRequired',
        'payerAuthenticationEnabled' => 'getPayerAuthenticationEnabled'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['cardVerificationNumberSupported'] = isset($data['cardVerificationNumberSupported']) ? $data['cardVerificationNumberSupported'] : null;
        $this->container['cardVerificationNumberDisplay'] = isset($data['cardVerificationNumberDisplay']) ? $data['cardVerificationNumberDisplay'] : null;
        $this->container['payerAuthenticationSupported'] = isset($data['payerAuthenticationSupported']) ? $data['payerAuthenticationSupported'] : null;
        $this->container['supportedCurrencies'] = isset($data['supportedCurrencies']) ? $data['supportedCurrencies'] : null;
        $this->container['method'] = isset($data['method']) ? $data['method'] : null;
        $this->container['cardVerificationNumberRequired'] = isset($data['cardVerificationNumberRequired']) ? $data['cardVerificationNumberRequired'] : null;
        $this->container['payerAuthenticationEnabled'] = isset($data['payerAuthenticationEnabled']) ? $data['payerAuthenticationEnabled'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets cardVerificationNumberSupported
     * @return bool
     */
    public function getCardVerificationNumberSupported()
    {
        return $this->container['cardVerificationNumberSupported'];
    }

    /**
     * Sets cardVerificationNumberSupported
     * @param bool $cardVerificationNumberSupported Dictates whether or Card Verification Number is supported by the card type. Usually this is set at system level.
     * @return $this
     */
    public function setCardVerificationNumberSupported($cardVerificationNumberSupported)
    {
        $this->container['cardVerificationNumberSupported'] = $cardVerificationNumberSupported;

        return $this;
    }

    /**
     * Gets cardVerificationNumberDisplay
     * @return bool
     */
    public function getCardVerificationNumberDisplay()
    {
        return $this->container['cardVerificationNumberDisplay'];
    }

    /**
     * Sets cardVerificationNumberDisplay
     * @param bool $cardVerificationNumberDisplay Toggles whether or Card Verification Number is displayed on the Hosted Checkout.
     * @return $this
     */
    public function setCardVerificationNumberDisplay($cardVerificationNumberDisplay)
    {
        $this->container['cardVerificationNumberDisplay'] = $cardVerificationNumberDisplay;

        return $this;
    }

    /**
     * Gets payerAuthenticationSupported
     * @return bool
     */
    public function getPayerAuthenticationSupported()
    {
        return $this->container['payerAuthenticationSupported'];
    }

    /**
     * Sets payerAuthenticationSupported
     * @param bool $payerAuthenticationSupported Dictates whether or Payer Authentication is supported by the card type. Usually this is set at system level.
     * @return $this
     */
    public function setPayerAuthenticationSupported($payerAuthenticationSupported)
    {
        $this->container['payerAuthenticationSupported'] = $payerAuthenticationSupported;

        return $this;
    }

    /**
     * Gets supportedCurrencies
     * @return string[]
     */
    public function getSupportedCurrencies()
    {
        return $this->container['supportedCurrencies'];
    }

    /**
     * Sets supportedCurrencies
     * @param string[] $supportedCurrencies Array of the supported  ISO 4217 alphabetic currency codes.
     * @return $this
     */
    public function setSupportedCurrencies($supportedCurrencies)
    {
        $this->container['supportedCurrencies'] = $supportedCurrencies;

        return $this;
    }

    /**
     * Gets method
     * @return string
     */
    public function getMethod()
    {
        return $this->container['method'];
    }

    /**
     * Sets method
     * @param string $method
     * @return $this
     */
    public function setMethod($method)
    {
        $this->container['method'] = $method;

        return $this;
    }

    /**
     * Gets cardVerificationNumberRequired
     * @return bool
     */
    public function getCardVerificationNumberRequired()
    {
        return $this->container['cardVerificationNumberRequired'];
    }

    /**
     * Sets cardVerificationNumberRequired
     * @param bool $cardVerificationNumberRequired
     * @return $this
     */
    public function setCardVerificationNumberRequired($cardVerificationNumberRequired)
    {
        $this->container['cardVerificationNumberRequired'] = $cardVerificationNumberRequired;

        return $this;
    }

    /**
     * Gets payerAuthenticationEnabled
     * @return bool
     */
    public function getPayerAuthenticationEnabled()
    {
        return $this->container['payerAuthenticationEnabled'];
    }

    /**
     * Sets payerAuthenticationEnabled
     * @param bool $payerAuthenticationEnabled
     * @return $this
     */
    public function setPayerAuthenticationEnabled($payerAuthenticationEnabled)
    {
        $this->container['payerAuthenticationEnabled'] = $payerAuthenticationEnabled;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


