<?php
$page_title = "Xtra Market";

$page_url = get_site_url();
//echo '$page-url = ' . $page_url . '</br>';

$cart_count = 0;
if(isset($_SESSION['user_id']) && isset($_SESSION['order_id'])) {
    $cart_count = getCartProductsCount($_SESSION['user_id'], $_SESSION['order_id']);
}

function load_index_files_function()
{
    wp_enqueue_style('index-style', get_template_directory_uri() . '/css/index.css');
    wp_enqueue_style('basket-style', get_template_directory_uri() . '/css/basket-cart.css');
}

add_action('wp_enqueue_scripts', 'load_index_files_function');
?>

<!-- Header -->
<?php get_header(); ?>

<script type="text/javascript">
    const page = "index.php";
</script>

<section class="products-section">

    <div class="products-container">

        <div class="products-column-1">
            <div class="products-column-1-row-1">
                <div class="product product-1-container">
                    <div class="product-1-description">
                        <h2>50% OFF</h2>
                        <h1>Sauces</h1>
                    </div>
                    <img class="product-1-image" src="<?php echo get_template_directory_uri(); ?>/images/products/product-1.png"
                        alt="product-1" style="">
                </div>
                <div class="product product-2-container">
                    <div class="product-2-description">
                        <h2>50% OFF</h2>
                        <h1>All Chips</h1>
                    </div>
                    <img class="product-2-image" src="<?php echo get_template_directory_uri(); ?>/images/products/product-2.png"
                        alt="product-2" style="">
                </div>
            </div>
            <div class="products-column-1-row-2">
                <div class="product-3-description">
                    <h3>50% OFF</h3>
                    <h2>Sale 58% Off</h2>
                    <h1>All Fruit Products</h1>
                    <button class="shop-button-1">SHOP NOW</button>
                </div>
                <img class="product-3-image" src="<?php echo get_template_directory_uri(); ?>/images/products/product-3.png"
                    alt="product-3" style="">
            </div>
        </div>

        <div class="products-column-2">
            <div class="product-4-description">
                <h2>50% OFF</h2>
                <h1>Full Fresh Vegetable </h1>
                <button class="shop-button-2">SHOP NOW</button>
            </div>
            <img class="product-4-image" src="<?php echo get_template_directory_uri(); ?>/images/products/product-4.png" alt="product-4"
                style="">
        </div>

    </div>

</section>

<section class="categories-section">

    <h1>Discover our <span>Categories</span></h1>

    <div class="categories-container">

        <div class="category-class">
            <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/fish.png" alt="fish">
            <h1>Fishes and Raw Meats</h1>
        </div>
        <div class="category-class">
            <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/vegetables.png" alt="vegetables">
            <h1>Fruits and Vegetables</h1>
        </div>
        <div class="category-class">
            <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/bread.png" alt="bread">
            <h1>Breads and Sweats</h1>
        </div>
        <div class="category-class">
            <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/milk.png" alt="milk">
            <h1>Milks and Proteins</h1>
        </div>
        <div class="category-class">
            <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/materials.png" alt="materials">
            <h1>Cleaning Materials</h1>
        </div>
        <div class="category-class">
            <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/meat.png" alt="meat">
            <h1>Ready touse Foods</h1>
        </div>

    </div>
</section>

<section class="best-seller-section">
    <div class="best-seller-container">

        <div class="best-seller-title">
            <div>
                <h1>Best Seller <span>Products</span></h1>
            </div>

            <div>
                <a href="#" class="view-all-products-button">View all Products</a>
                <a href="./pages/wishlist.php" class="view-wishlist-button">View your Wishlist</a>
            </div>

        </div>

        <div class="best-seller-products">

            <?php
            $sql = "SELECT * FROM wp_extra_products";

            $products = $wpdb->get_results($sql);
            //echo '<pre>' . print_r($products, true) . '</pre>';

            //$result = $conn->query($sql);

            if ($products && count($products) > 0) {
                // Output data of each row
                foreach ($products as $product) {
            
                    ?>
                    <div class="product-card">
                        <img src="<?php echo get_template_directory_uri(); ?>/<?php echo $product->Image; ?>" alt="<?php echo $product->Name; ?>">
                        <h1><?php echo $product->Name; ?></h1>
                        <p><?php echo $product->Nature; ?></p>
                        <div class="vote">
                            <?php
                            $vote = $product->Vote;
                            for ($i = 1; $i <= $vote; $i++) {
                                //echo "filled$i";
                                ?>
                                <i class="fa-solid fa-star filled-star"></i>
                                <?php
                            }
                            for ($i = ($vote + 1); $i <= 5; $i++) {
                                //echo "empty$i";
                                ?>
                                <i class="fa-regular fa-star empty-star"></i>
                                <?php
                            }
                            ?>

                            <?php
                            $oldPrice = $product->OldPrice;
                            $newPrice = $product->NewPrice;
                            if ($oldPrice != $newPrice) {
                                ?>
                                <span class="old-price">$<?php echo $oldPrice; ?></span>
                                <?php
                            }
                            ?>
                            <span class="new-price">$<?php echo $newPrice; ?></span>
                        </div>

                        <?php
                        $heartEnabledDisplay = "";
                        $heartDisabledDisplay = "heart-disabled-displayed";

                        if (isset($_SESSION['username'])) {
                            $isProductInWishlist = isProductInWishlist( $_SESSION['user_id'], $product->Id);

                            if ($isProductInWishlist) {
                                $heartEnabledDisplay = "heart-enabled-displayed";
                                $heartDisabledDisplay = "";
                            } else {
                                $heartEnabledDisplay = "";
                                $heartDisabledDisplay = "heart-disabled-displayed";
                            }
                        }
                        ?>

                        <i id="heart-disabled-<?php echo $product->Id; ?>"
                            class="fa-regular fa-heart heart-disabled-icon <?php echo $heartDisabledDisplay; ?>"
                            onclick="addProductToWishlist(<?php echo $product->Id; ?>)"></i>
                        <div class="heart-disabled-action">Add to wishlist</div>

                        <i id="heart-enabled-<?php echo $product->Id; ?>"
                            class="fa-solid fa-heart heart-enabled-icon <?php echo $heartEnabledDisplay; ?>"
                            onclick="removeProductFromWishlist(<?php echo $product->Id; ?>)"></i>
                        <div class="heart-enabled-action">Remove from wishlist</div>

                        <i class="fa-solid fa-shuffle compare-icon"></i>
                        <div class="add-to-compare-action">Add to compare</div>

                        <i class="fa-solid fa-magnifying-glass quick-view-icon"></i>
                        <div class="quick-view-action">Quick view</div>

                        <button class="add-to-cart-button" onclick="addProductToCart(<?php echo $product->Id; ?>);">
                            <i class="fa-solid fa-cart-shopping"></i> <span id="add-to-cart-text-<?php echo $product->Id; ?>">Add
                                to cart</span>
                        </button>
                    </div>
                    <?php
                }
            } else {
                echo "0 results";
            }

            ?>

        </div>

    </div>

</section>

<section class="mobile-app-section">
    <div class="mobile-app-container">

        <div class="mobile-app-description">
            <h2>XtraSupermarket</h2>
            <h1>Faster on Mobile</h1>
            <p>A supermarket is a self-service shop offering a wide variety of food, beverages and household
                products, organized into sections.</p>
            <div class="mobile-app-buttons">
                <img class="img1" src="<?php echo get_template_directory_uri(); ?>/images/download-app-store.png"
                    alt="download-app-store">
                <img class="img2" src="<?php echo get_template_directory_uri(); ?>/images/download-google-play.png"
                    alt="download-google-play">
            </div>
        </div>

        <div class="mobile-app-image-container">
            <img src="<?php echo get_template_directory_uri(); ?>/images/mobile-app.png" alt="mobile-app">
        </div>

    </div>

</section>

<section class="blog-section">
    <div class="blog-container">


        <div class="blog-title">
            <div>
                <h1>Latest <span>News & Blog</span></h1>
            </div>

            <div class="navigation-buttons">
                <i class="fa-solid fa-arrow-left left-button"></i>
                <i class="fa-solid fa-arrow-right right-button"></i>
            </div>
        </div>

        <div class="blog-carousel-container">
            <div class="blog-carousel sliding-transition">

                <div class="carousel-card">
                    <div class="card-image-wrapper">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/blog/blog-image-1.jpg"
                            alt="March retail sales, foot traffic take a dip">
                        <div class="card-overlay">
                            <i class="fa-solid fa-link link-icon"></i>
                        </div>
                    </div>
                    <h2>
                        10 June 2024 </h2>
                    <h1>March retail sales, foot traffic take a dip</h1>
                    <div class="blog-type">Tutorial</div>
                </div>
                <div class="carousel-card">
                    <div class="card-image-wrapper">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/blog/blog-image-2.jpg"
                            alt="Kroger ready to exapnd technology reach">
                        <div class="card-overlay">
                            <i class="fa-solid fa-link link-icon"></i>
                        </div>
                    </div>
                    <h2>
                        10 June 2024 </h2>
                    <h1>Kroger ready to exapnd technology reach</h1>
                    <div class="blog-type">Interview</div>
                </div>
                <div class="carousel-card">
                    <div class="card-image-wrapper">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/blog/blog-image-3.jpg"
                            alt="Coborn's to acquire Sullivan's Foods in Illinois">
                        <div class="card-overlay">
                            <i class="fa-solid fa-link link-icon"></i>
                        </div>
                    </div>
                    <h2>
                        10 June 2024 </h2>
                    <h1>Coborn's to acquire Sullivan's Foods in Illinois</h1>
                    <div class="blog-type">News</div>
                </div>
                <div class="carousel-card">
                    <div class="card-image-wrapper">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/blog/blog-image-4.jpg"
                            alt="Whole Foods announces layoffs, restructuring">
                        <div class="card-overlay">
                            <i class="fa-solid fa-link link-icon"></i>
                        </div>
                    </div>
                    <h2>
                        10 June 2024 </h2>
                    <h1>Whole Foods announces layoffs, restructuring</h1>
                    <div class="blog-type">Updates</div>
                </div>
                <div class="carousel-card">
                    <div class="card-image-wrapper">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/blog/blog-image-5.jpg"
                            alt="Wallmart adds first-of-its-kind truck to fleet">
                        <div class="card-overlay">
                            <i class="fa-solid fa-link link-icon"></i>
                        </div>
                    </div>
                    <h2>
                        10 June 2024 </h2>
                    <h1>Wallmart adds first-of-its-kind truck to fleet</h1>
                    <div class="blog-type">News</div>
                </div>
                <div class="carousel-card">
                    <div class="card-image-wrapper">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/blog/blog-image-6.jpg"
                            alt="Metro sales were on the rise in Q2">
                        <div class="card-overlay">
                            <i class="fa-solid fa-link link-icon"></i>
                        </div>
                    </div>
                    <h2>
                        10 June 2024 </h2>
                    <h1>Metro sales were on the rise in Q2</h1>
                    <div class="blog-type">Tutorial</div>
                </div>

            </div>

        </div>

    </div>

</section>


<!-- Footer -->
<?php get_footer(); ?>