<script type="text/javascript">
    const page = "cart.php";
</script>

<div class="cart-section">
    <div class="cart-head">
        <h1>Cart</h1>
        <div class="breadcrumbs">
            <i class="fa-solid fa-house"></i>
            <i class="fa-solid fa-angle-right"></i>
            Cart
        </div>
    </div>

    <?php
    if (isset($_SESSION['username'])) {
        ?>

        <div class="cart-body">

            <div class="payment-process">
                <a href="<?php echo get_site_url() . '/cart/'; ?>"
                    class="payment-process-step payment-process-step-selected">
                    <div class="process-step-number">1</div>
                    <h1>Shopping cart</h1>
                </a>
                <div class="payment-process-separator"><i class="fa-solid fa-arrow-right"></i></div>
                <a href="<?php echo get_site_url() . '/checkout/'; ?>" class="payment-process-step">
                    <div class="process-step-number">2</div>
                    <h1>Checkout details</h1>
                </a>
                <div class="payment-process-separator"><i class="fa-solid fa-arrow-right"></i></div>
                <a href="<?php echo get_site_url() . '/order/'; ?>" class="payment-process-step">
                    <div class="process-step-number">3</div>
                    <h1>Order complete</h1>
                </a>
            </div>

            <?php
                echo do_shortcode('[products]');

                echo do_shortcode('[woocommerce_cart]');
                if(false) {
                ?>

            <div class="shopping-cart-table-wrapper">
                
                <table class="shopping-cart-table">
                    <tr>
                        <th></th>
                        <th></th>
                        <th>Product</th>
                        <th>Price</th>
                        <th>Quantity</th>
                        <th>Subtotal</th>
                    </tr>

                    <?php
                    if (isset($_SESSION['order_id'])) {
                        $sql = "SELECT * FROM wp_extra_cart_products cp  
                        JOIN wp_extra_orders o ON cp.orderId = o.orderId AND cp.userId = o.userId 
                        JOIN wp_extra_products p ON cp.productId = p.Id 
                        WHERE cp.userId = " . $_SESSION['user_id'] . " 
                        AND cp.orderId = " . $_SESSION['order_id'] . " 
                        ;";
                        //echo '$sql: ' . $sql . '<br>';

                        try {
                            $products = $wpdb->get_results($sql);
                            //echo '<pre>' . print_r($products, true) . '</pre>';

                            if ($products && count($products) > 0) {

                                $i = 0;
                                $total = 0;
                                $subTotals = "";
                                foreach ($products as $product) {
                                    ?>

                                    <tr>
                                        <td>
                                            <i class="fa-solid fa-xmark remove-product-icon"
                                                onclick="removeProductFromCart(<?php echo $product->productId; ?>);"></i>
                                        </td>
                                        <td>
                                            <img src="<?php echo get_template_directory_uri() . $product->Image ?>" alt="product_image">
                                        </td>
                                        <td>
                                            <?php echo $product->Name ?>
                                        </td>
                                        <td>

                                            $<span id="product-price-<?php echo $product->productId ?>"><?php echo $product->NewPrice ?></span>
                                        </td>
                                        <td>

                                            <div class="quantity-container">
                                                <button class="reduce-quantity"
                                                    onclick="reduceQuantity(<?php echo $product->productId ?>);"><i
                                                        class="fa-solid fa-minus"></i></button>
                                                <input id="quantity-input-<?php echo $product->productId ?>" class="quantity-input"
                                                    type="text" value="<?php echo $product->quantity ?>">
                                                <button class="add-quantity" onclick="addQuantity(<?php echo $product->productId ?>);"><i
                                                        class="fa-solid fa-plus"></i></button>

                                            </div>
                                        </td>
                                        <td>
                                            <?php
                                            $subTotal = $product->NewPrice * $product->quantity;
                                            $total += $subTotal;
                                            $subTotals .= '$' . $subTotal;
                                            $i++;
                                            if ($i < count($products))
                                                $subTotals .= ' + ';

                                            ?>
                                            $<span class="product-subtotal"
                                                id="product-subtotal-<?php echo $product->productId ?>"><?php echo ($product->NewPrice * $product->quantity) ?></span>
                                        </td>
                                    </tr>

                                    <?php
                                }
                            }
                        } catch (Exception $ex) {
                            echo 'Exception: ' . $ex->getMessage() . '<br>';
                        }
                    }



                    ?>

                    <tr>
                        <td colspan="6">
                            <a class="continue-shopping-link" href="<?php echo get_site_url() . '/' ?>">Continue shopping</a>
                        </td>
                    </tr>

                </table>

            </div>

            <div class="cart-total">
                <div class="cart-total-title">Cart totals</div>

                <table class="cart-total-table">
                    <tr>
                        <td><strong>Subtotals</strong></td>
                        <td>
                            <span id="cart-subtotals"><?php echo $subTotals ?? '$0'; ?></span>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Total</strong></td>
                        <td>
                            $<span id="cart-total"><?php echo $total ?? '0'; ?></span>
                        </td>
                    </tr>
                </table>
                <a class="proceed-checkout-link" href="<?php echo get_site_url() . '/checkout/' ?>">Proceed to
                    checkout</a>
            </div>

            
            <?php
                }
            ?>

        </div>
        <?php
    }
    ?>


</div>