<?php
/**
 * Wishlist management
 */

function isProductInWishlist($user_id, $product_id)
{
    global $wpdb;

    $sql = "SELECT * FROM wp_extra_wishlist_products 
            WHERE userId = " . $user_id . " 
            AND productId = " . $product_id . " 
            ;";
    //echo '$sql: ' . $sql . '<br>';

    try {
        $products = $wpdb->get_results($sql);
        //echo '<pre>' . print_r($products, true) . '</pre>';
        if ($products && count($products) > 0) {
            return true;
        } else {
            return false;
        }

    } catch (Exception $ex) {
        echo 'Exception: ' . $ex->getMessage() . '<br>';
        return false;
    }
}

/**
 * Shopping cart management
 */

function getCartProductsCount($user_id, $order_id)
{
    global $wpdb;

    $sql = "SELECT * FROM wp_extra_cart_products 
            WHERE userId = " . $user_id . " 
            AND orderId = " . $order_id . " 
            ;";
    //echo '$sql : ' . $sql . '<br>';

    try {
        $results = $wpdb->get_results($sql);
        return count($results);

    } catch (Exception $ex) {
        echo 'Exception: ' . $ex->getMessage() . '<br>';
    }
}
function addProductQuantity($product_id, $user_id, $order_id)
{
    global $wpdb;

    $sql = "SELECT * FROM wp_extra_cart_products 
            WHERE productId = " . $product_id . " 
            AND userId = " . $user_id . " 
            AND orderId = " . $order_id . " 
            ;";

    try {
        $results = $wpdb->get_results($sql);

        if ($results && count($results) > 0) {
            $quantity = $results[0]->quantity;
            $quantity++;

            $sql = "UPDATE wp_extra_cart_products 
                    SET quantity = " . $quantity . " 
                    WHERE productId = " . $product_id . " 
                    AND userId = " . $user_id . " 
                    AND orderId = " . $order_id . " 
                    ;";

            $result = $wpdb->query($sql);
            if ($result === false) {
                $error_message = $wpdb->last_error;
                throw new Exception($error_message);
            } else {
                return $quantity;
            }
        }
    } catch (Exception $ex) {
        throw $ex;
    }
}

function reduceProductQuantity($product_id, $user_id, $order_id)
{
    global $wpdb;

    $sql = "SELECT * FROM wp_extra_cart_products 
            WHERE productId = " . $product_id . " 
            AND userId = " . $user_id . " 
            AND orderId = " . $order_id . " 
            ;";

    try {
        $results = $wpdb->get_results($sql);
        if ($results && count($results) > 0) {
            $quantity = $results[0]->quantity;
            if ($quantity > 0)
                $quantity--;

            $sql = "UPDATE wp_extra_cart_products 
                    SET quantity = " . $quantity . " 
                    WHERE productId = " . $product_id . " 
                    AND userId = " . $user_id . " 
                    AND orderId = " . $order_id . " 
                    ;";

            $result = $wpdb->query($sql);
            if ($result === false) {
                $error_message = $wpdb->last_error;
                throw new Exception($error_message);
            } else {
                return $quantity;
            }
        }
    } catch (Exception $ex) {
        throw $ex;
    }
}

function finalizeOrder($user_id, $order_id)
{
    global $wpdb;

    $sql = "UPDATE wp_extra_orders 
            SET status = 'Finalized' 
            WHERE userId = " . $user_id . " 
            AND orderId = " . $order_id . " 
            ;";

    try {
        $wpdb->query($sql);

    } catch (Exception $ex) {
        echo 'Exception: ' . $ex->getMessage() . '<br>';
    }

}

function createNewOrder($user_id)
{
    global $wpdb;

    $sql = "SELECT * FROM wp_extra_orders 
            WHERE userId = " . $user_id . " 
            ORDER BY orderId DESC LIMIT 1 
            ;";

    try {
        $results = $wpdb->get_results($sql);
        if ($results && count($results) > 0) {
            $result = $results[0];

            if ($result->status == 'Initialized') {
                return $result->orderId;
            } else {
                $order_id = $result->orderId + 1;

                createOrder($user_id, $order_id);
                return $order_id;
            }
        } else {
            createOrder(1, $user_id);
            return 1;
        }

    } catch (Exception $ex) {
        echo 'Exception: ' . $ex->getMessage() . '<br>';
    }
}

function createOrder($order_id, $user_id)
{
    global $wpdb;

    $newDateTime = new DateTime();
    $currentDateTime = $newDateTime->format("Y-m-d H:i:s");

    $sql = "INSERT INTO wp_extra_orders (orderId, userId, orderDate, status) 
                        VALUES(" . $order_id . ", " . $user_id . ", '" . $currentDateTime . "', 'Initialized')
                        ;";
    $wpdb->query($sql);
}
?>